/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.client;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SettableListenableFuture;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.handler.TextWebSocketHandler;
import org.springframework.web.socket.sockjs.client.Transport;
import org.springframework.web.socket.sockjs.client.TransportRequest;
import org.springframework.web.socket.sockjs.client.WebSocketClientSockJsSession;
import org.springframework.web.socket.sockjs.transport.TransportType;

public class WebSocketTransport
implements Transport,
Lifecycle {
    private static Log logger = LogFactory.getLog(WebSocketTransport.class);
    private final WebSocketClient webSocketClient;
    private volatile boolean running = false;

    public WebSocketTransport(WebSocketClient webSocketClient) {
        Assert.notNull((Object)webSocketClient, (String)"'webSocketClient' is required");
        this.webSocketClient = webSocketClient;
    }

    @Override
    public List<TransportType> getTransportTypes() {
        return Arrays.asList(TransportType.WEBSOCKET);
    }

    public WebSocketClient getWebSocketClient() {
        return this.webSocketClient;
    }

    public void start() {
        if (!this.isRunning()) {
            if (this.webSocketClient instanceof Lifecycle) {
                ((Lifecycle)this.webSocketClient).start();
            } else {
                this.running = true;
            }
        }
    }

    public void stop() {
        if (this.isRunning()) {
            if (this.webSocketClient instanceof Lifecycle) {
                ((Lifecycle)this.webSocketClient).stop();
            } else {
                this.running = false;
            }
        }
    }

    public boolean isRunning() {
        if (this.webSocketClient instanceof Lifecycle) {
            return ((Lifecycle)this.webSocketClient).isRunning();
        }
        return this.running;
    }

    @Override
    public ListenableFuture<WebSocketSession> connect(TransportRequest request, WebSocketHandler handler) {
        final SettableListenableFuture future = new SettableListenableFuture();
        WebSocketClientSockJsSession session = new WebSocketClientSockJsSession(request, handler, (SettableListenableFuture<WebSocketSession>)future);
        handler = new ClientSockJsWebSocketHandler(session);
        request.addTimeoutTask(session.getTimeoutTask());
        URI url = request.getTransportUrl();
        WebSocketHttpHeaders headers = new WebSocketHttpHeaders(request.getHandshakeHeaders());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting WebSocket session url=" + url));
        }
        this.webSocketClient.doHandshake(handler, headers, url).addCallback((ListenableFutureCallback)new ListenableFutureCallback<WebSocketSession>(){

            public void onSuccess(WebSocketSession webSocketSession) {
            }

            public void onFailure(Throwable t) {
                future.setException(t);
            }
        });
        return future;
    }

    public String toString() {
        return "WebSocketTransport[client=" + this.webSocketClient + "]";
    }

    private static class ClientSockJsWebSocketHandler
    extends TextWebSocketHandler {
        private final WebSocketClientSockJsSession sockJsSession;
        private final AtomicInteger connectCount = new AtomicInteger(0);

        private ClientSockJsWebSocketHandler(WebSocketClientSockJsSession session) {
            Assert.notNull((Object)session);
            this.sockJsSession = session;
        }

        @Override
        public void afterConnectionEstablished(WebSocketSession webSocketSession) throws Exception {
            Assert.isTrue((boolean)this.connectCount.compareAndSet(0, 1));
            this.sockJsSession.initializeDelegateSession(webSocketSession);
        }

        @Override
        public void handleTextMessage(WebSocketSession webSocketSession, TextMessage message) throws Exception {
            this.sockJsSession.handleFrame((String)message.getPayload());
        }

        @Override
        public void handleTransportError(WebSocketSession webSocketSession, Throwable ex) throws Exception {
            this.sockJsSession.handleTransportError(ex);
        }

        @Override
        public void afterConnectionClosed(WebSocketSession webSocketSession, CloseStatus status) throws Exception {
            this.sockJsSession.afterTransportClosed(status);
        }
    }
}

