/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.support;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsException;
import org.springframework.web.socket.sockjs.SockJsService;

public abstract class AbstractSockJsService
implements SockJsService {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final long ONE_YEAR = TimeUnit.DAYS.toSeconds(365L);
    private static final Random random = new Random();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final TaskScheduler taskScheduler;
    private String name = "SockJSService@" + ObjectUtils.getIdentityHexString((Object)this);
    private String clientLibraryUrl = "https://cdn.jsdelivr.net/sockjs/0.3.4/sockjs.min.js";
    private int streamBytesLimit = 131072;
    private boolean sessionCookieNeeded = true;
    private long heartbeatTime = 25000L;
    private long disconnectDelay = 5000L;
    private int httpMessageCacheSize = 100;
    private boolean webSocketEnabled = true;
    private final List<String> allowedOrigins = new ArrayList<String>(Arrays.asList("*"));
    private boolean suppressCors = false;
    private final SockJsRequestHandler infoHandler = new SockJsRequestHandler(){
        private static final String INFO_CONTENT = "{\"entropy\":%s,\"origins\":[\"*:*\"],\"cookie_needed\":%s,\"websocket\":%s}";

        @Override
        public void handle(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
            if (HttpMethod.GET.equals((Object)request.getMethod())) {
                AbstractSockJsService.this.addNoCacheHeaders(response);
                if (AbstractSockJsService.this.checkAndAddCorsHeaders(request, response, new HttpMethod[0])) {
                    response.getHeaders().setContentType(new MediaType("application", "json", UTF8_CHARSET));
                    String content = String.format(INFO_CONTENT, random.nextInt(), AbstractSockJsService.this.isSessionCookieNeeded(), AbstractSockJsService.this.isWebSocketEnabled());
                    response.getBody().write(content.getBytes());
                }
            } else if (HttpMethod.OPTIONS.equals((Object)request.getMethod())) {
                if (AbstractSockJsService.this.checkAndAddCorsHeaders(request, response, HttpMethod.OPTIONS, HttpMethod.GET)) {
                    AbstractSockJsService.this.addCacheHeaders(response);
                    response.setStatusCode(HttpStatus.NO_CONTENT);
                }
            } else {
                AbstractSockJsService.this.sendMethodNotAllowed(response, HttpMethod.OPTIONS, HttpMethod.GET);
            }
        }
    };
    private final SockJsRequestHandler iframeHandler = new SockJsRequestHandler(){
        private static final String IFRAME_CONTENT = "<!DOCTYPE html>\n<html>\n<head>\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n  <script>\n    document.domain = document.domain;\n    _sockjs_onload = function(){SockJS.bootstrap_iframe();};\n  </script>\n  <script src=\"%s\"></script>\n</head>\n<body>\n  <h2>Don't panic!</h2>\n  <p>This is a SockJS hidden iframe. It's used for cross domain magic.</p>\n</body>\n</html>";

        @Override
        public void handle(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
            if (!HttpMethod.GET.equals((Object)request.getMethod())) {
                AbstractSockJsService.this.sendMethodNotAllowed(response, HttpMethod.GET);
                return;
            }
            String content = String.format(IFRAME_CONTENT, AbstractSockJsService.this.getSockJsClientLibraryUrl());
            byte[] contentBytes = content.getBytes(UTF8_CHARSET);
            StringBuilder builder = new StringBuilder("\"0");
            DigestUtils.appendMd5DigestAsHex((byte[])contentBytes, (StringBuilder)builder);
            builder.append('\"');
            String etagValue = builder.toString();
            List ifNoneMatch = request.getHeaders().getIfNoneMatch();
            if (!CollectionUtils.isEmpty((Collection)ifNoneMatch) && ((String)ifNoneMatch.get(0)).equals(etagValue)) {
                response.setStatusCode(HttpStatus.NOT_MODIFIED);
                return;
            }
            response.getHeaders().setContentType(new MediaType("text", "html", UTF8_CHARSET));
            response.getHeaders().setContentLength((long)contentBytes.length);
            AbstractSockJsService.this.addCacheHeaders(response);
            response.getHeaders().setETag(etagValue);
            response.getBody().write(contentBytes);
        }
    };

    public AbstractSockJsService(TaskScheduler scheduler) {
        Assert.notNull((Object)scheduler, (String)"TaskScheduler must not be null");
        this.taskScheduler = scheduler;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSockJsClientLibraryUrl(String clientLibraryUrl) {
        this.clientLibraryUrl = clientLibraryUrl;
    }

    public String getSockJsClientLibraryUrl() {
        return this.clientLibraryUrl;
    }

    public void setStreamBytesLimit(int streamBytesLimit) {
        this.streamBytesLimit = streamBytesLimit;
    }

    public int getStreamBytesLimit() {
        return this.streamBytesLimit;
    }

    public void setSessionCookieNeeded(boolean sessionCookieNeeded) {
        this.sessionCookieNeeded = sessionCookieNeeded;
    }

    public boolean isSessionCookieNeeded() {
        return this.sessionCookieNeeded;
    }

    public void setHeartbeatTime(long heartbeatTime) {
        this.heartbeatTime = heartbeatTime;
    }

    public long getHeartbeatTime() {
        return this.heartbeatTime;
    }

    public void setDisconnectDelay(long disconnectDelay) {
        this.disconnectDelay = disconnectDelay;
    }

    public long getDisconnectDelay() {
        return this.disconnectDelay;
    }

    public void setHttpMessageCacheSize(int httpMessageCacheSize) {
        this.httpMessageCacheSize = httpMessageCacheSize;
    }

    public int getHttpMessageCacheSize() {
        return this.httpMessageCacheSize;
    }

    public void setWebSocketEnabled(boolean webSocketEnabled) {
        this.webSocketEnabled = webSocketEnabled;
    }

    public boolean isWebSocketEnabled() {
        return this.webSocketEnabled;
    }

    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins.clear();
        if (allowedOrigins != null) {
            this.allowedOrigins.addAll(allowedOrigins);
        }
    }

    public List<String> getAllowedOrigins() {
        return Collections.unmodifiableList(this.allowedOrigins);
    }

    public void setSuppressCors(boolean suppressCors) {
        this.suppressCors = suppressCors;
    }

    public boolean shouldSuppressCors() {
        return this.suppressCors;
    }

    @Override
    public final void handleRequest(ServerHttpRequest request, ServerHttpResponse response, String sockJsPath, WebSocketHandler wsHandler) throws SockJsException {
        if (sockJsPath == null) {
            this.logger.error((Object)("Expected SockJS path. Failing request: " + request.getURI()));
            response.setStatusCode(HttpStatus.NOT_FOUND);
            return;
        }
        try {
            request.getHeaders();
        }
        catch (InvalidMediaTypeException ex) {
            // empty catch block
        }
        String requestInfo = this.logger.isDebugEnabled() ? request.getMethod() + " " + request.getURI() : "";
        try {
            if (sockJsPath.equals("") || sockJsPath.equals("/")) {
                this.logger.debug((Object)requestInfo);
                response.getHeaders().setContentType(new MediaType("text", "plain", UTF8_CHARSET));
                response.getBody().write("Welcome to SockJS!\n".getBytes(UTF8_CHARSET));
            } else if (sockJsPath.equals("/info")) {
                this.logger.debug((Object)requestInfo);
                this.infoHandler.handle(request, response);
            } else if (sockJsPath.matches("/iframe[0-9-.a-z_]*.html")) {
                this.logger.debug((Object)requestInfo);
                this.iframeHandler.handle(request, response);
            } else if (sockJsPath.equals("/websocket")) {
                if (this.isWebSocketEnabled()) {
                    this.logger.debug((Object)requestInfo);
                    this.handleRawWebSocketRequest(request, response, wsHandler);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("WebSocket disabled, ignoring " + requestInfo));
                }
            } else {
                String[] pathSegments = StringUtils.tokenizeToStringArray((String)sockJsPath.substring(1), (String)"/");
                if (pathSegments.length != 3) {
                    this.logger.error((Object)("Ignoring invalid transport request " + requestInfo));
                    response.setStatusCode(HttpStatus.NOT_FOUND);
                    return;
                }
                String serverId = pathSegments[0];
                String sessionId = pathSegments[1];
                String transport = pathSegments[2];
                if (!this.isWebSocketEnabled() && transport.equals("websocket")) {
                    this.logger.debug((Object)("WebSocket transport is disabled, ignoring " + requestInfo));
                    response.setStatusCode(HttpStatus.NOT_FOUND);
                    return;
                }
                if (!this.validateRequest(serverId, sessionId, transport)) {
                    this.logger.error((Object)("Ignoring transport request " + requestInfo));
                    response.setStatusCode(HttpStatus.NOT_FOUND);
                    return;
                }
                this.handleTransportRequest(request, response, wsHandler, sessionId, transport);
            }
            response.close();
        }
        catch (IOException ex) {
            throw new SockJsException("Failed to write to the response", null, ex);
        }
    }

    protected boolean validateRequest(String serverId, String sessionId, String transport) {
        if (!(StringUtils.hasText((String)serverId) && StringUtils.hasText((String)sessionId) && StringUtils.hasText((String)transport))) {
            this.logger.error((Object)"No server, session, or transport path segment");
            return false;
        }
        if (serverId.contains(".") || sessionId.contains(".")) {
            this.logger.error((Object)"Either server or session contains a \".\" which is not allowed by SockJS protocol.");
            return false;
        }
        return true;
    }

    protected abstract void handleRawWebSocketRequest(ServerHttpRequest var1, ServerHttpResponse var2, WebSocketHandler var3) throws IOException;

    protected abstract void handleTransportRequest(ServerHttpRequest var1, ServerHttpResponse var2, WebSocketHandler var3, String var4, String var5) throws SockJsException;

    protected boolean checkAndAddCorsHeaders(ServerHttpRequest request, ServerHttpResponse response, HttpMethod ... httpMethods) {
        HttpHeaders requestHeaders = request.getHeaders();
        HttpHeaders responseHeaders = response.getHeaders();
        String origin = requestHeaders.getOrigin();
        if (!(this.allowedOrigins.contains("*") || origin != null && this.allowedOrigins.contains(origin))) {
            this.logger.debug((Object)("Request rejected, Origin header value " + origin + " not allowed"));
            response.setStatusCode(HttpStatus.FORBIDDEN);
            return false;
        }
        boolean hasCorsResponseHeaders = false;
        try {
            hasCorsResponseHeaders = !CollectionUtils.isEmpty((Collection)responseHeaders.get((Object)"Access-Control-Allow-Origin"));
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (!this.suppressCors && origin != null && !hasCorsResponseHeaders) {
            this.addCorsHeaders(request, response, httpMethods);
        }
        return true;
    }

    protected void addCorsHeaders(ServerHttpRequest request, ServerHttpResponse response, HttpMethod ... httpMethods) {
        HttpHeaders requestHeaders = request.getHeaders();
        HttpHeaders responseHeaders = response.getHeaders();
        responseHeaders.add("Access-Control-Allow-Origin", requestHeaders.getFirst("Origin"));
        responseHeaders.add("Access-Control-Allow-Credentials", "true");
        List accessControllerHeaders = requestHeaders.get((Object)"Access-Control-Request-Headers");
        if (accessControllerHeaders != null) {
            for (String header : accessControllerHeaders) {
                responseHeaders.add("Access-Control-Allow-Headers", header);
            }
        }
        if (!ObjectUtils.isEmpty((Object[])httpMethods)) {
            responseHeaders.add("Access-Control-Allow-Methods", StringUtils.arrayToDelimitedString((Object[])httpMethods, (String)", "));
            responseHeaders.add("Access-Control-Max-Age", String.valueOf(ONE_YEAR));
        }
        responseHeaders.add("Vary", "Origin");
    }

    protected void addCacheHeaders(ServerHttpResponse response) {
        response.getHeaders().setCacheControl("public, max-age=" + ONE_YEAR);
        response.getHeaders().setExpires(new Date().getTime() + ONE_YEAR * 1000L);
        response.getHeaders().add("Vary", "Origin");
    }

    protected void addNoCacheHeaders(ServerHttpResponse response) {
        response.getHeaders().setCacheControl("no-store, no-cache, must-revalidate, max-age=0");
    }

    protected void sendMethodNotAllowed(ServerHttpResponse response, HttpMethod ... httpMethods) {
        this.logger.error((Object)"Sending Method Not Allowed (405)");
        response.setStatusCode(HttpStatus.METHOD_NOT_ALLOWED);
        response.getHeaders().setAllow(new HashSet<HttpMethod>(Arrays.asList(httpMethods)));
    }

    private static interface SockJsRequestHandler {
        public void handle(ServerHttpRequest var1, ServerHttpResponse var2) throws IOException;
    }
}

