/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.destination;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.NamingException;
import org.springframework.jms.support.destination.DestinationResolutionException;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.jndi.JndiLocatorSupport;

public class JndiDestinationResolver
extends JndiLocatorSupport
implements DestinationResolver {
    private boolean cache = true;
    private boolean fallbackToDynamicDestination = false;
    private DestinationResolver dynamicDestinationResolver = new DynamicDestinationResolver();
    private final Map destinationCache = Collections.synchronizedMap(new HashMap());

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void setFallbackToDynamicDestination(boolean fallbackToDynamicDestination) {
        this.fallbackToDynamicDestination = fallbackToDynamicDestination;
    }

    public void setDynamicDestinationResolver(DestinationResolver dynamicDestinationResolver) {
        this.dynamicDestinationResolver = dynamicDestinationResolver;
    }

    public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
        Destination dest = (Destination)this.destinationCache.get(destinationName);
        if (dest == null) {
            try {
                dest = (Destination)this.lookup(destinationName);
            }
            catch (NamingException ex) {
                this.logger.debug((Object)("Destination [" + destinationName + "] not found in JNDI"), (Throwable)ex);
                if (this.fallbackToDynamicDestination) {
                    dest = this.dynamicDestinationResolver.resolveDestinationName(session, destinationName, pubSubDomain);
                }
                throw new DestinationResolutionException("Destination [" + destinationName + "] not found in JNDI", ex);
            }
            if (this.cache) {
                this.destinationCache.put(destinationName, dest);
            }
        }
        return dest;
    }
}

