/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.connection;

import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;
import org.springframework.jca.cci.connection.DelegatingConnectionFactory;

public class ConnectionSpecConnectionFactoryAdapter
extends DelegatingConnectionFactory {
    private ConnectionSpec connectionSpec;
    private final ThreadLocal threadBoundCredentials = new ThreadLocal();

    public void setConnectionSpec(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
    }

    public void setConnectionSpecForCurrentThread(ConnectionSpec spec) {
        this.threadBoundCredentials.set(spec);
    }

    public void removeConnectionSpecFromCurrentThread() {
        this.threadBoundCredentials.set(null);
    }

    public final Connection getConnection() throws ResourceException {
        ConnectionSpec threadSpec = (ConnectionSpec)this.threadBoundCredentials.get();
        if (threadSpec != null) {
            return this.doGetConnection(threadSpec);
        }
        return this.doGetConnection(this.connectionSpec);
    }

    protected Connection doGetConnection(ConnectionSpec spec) throws ResourceException {
        if (this.getTargetConnectionFactory() == null) {
            throw new IllegalStateException("targetConnectionFactory is required");
        }
        if (spec != null) {
            return this.getTargetConnectionFactory().getConnection(spec);
        }
        return this.getTargetConnectionFactory().getConnection();
    }
}

