/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.assembler;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.Descriptor;
import javax.management.JMException;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.jmx.export.assembler.AbstractMBeanInfoAssembler;
import org.springframework.jmx.support.JmxUtils;

public abstract class AbstractReflectiveMBeanInfoAssembler
extends AbstractMBeanInfoAssembler {
    private static final String VISIBILITY = "visibility";
    private static final Integer ATTRIBUTE_OPERATION_VISIBILITY = new Integer(4);
    private static final String ROLE = "role";
    private static final String GETTER = "getter";
    private static final String SETTER = "setter";
    private static final String OPERATION = "operation";
    protected static final String LOG = "log";
    protected static final String LOG_FILE = "logFile";
    protected static final String CURRENCY_TIME_LIMIT = "currencyTimeLimit";
    protected static final String DEFAULT = "default";
    protected static final String PERSIST_POLICY = "persistPolicy";
    protected static final String PERSIST_PERIOD = "persistPeriod";
    protected static final String PERSIST_LOCATION = "persistLocation";
    protected static final String PERSIST_NAME = "persistName";
    private Integer defaultCurrencyTimeLimit;
    private boolean useStrictCasing = true;
    static /* synthetic */ Class class$java$lang$Object;

    public void setDefaultCurrencyTimeLimit(Integer defaultCurrencyTimeLimit) {
        this.defaultCurrencyTimeLimit = defaultCurrencyTimeLimit;
    }

    protected Integer getDefaultCurrencyTimeLimit() {
        return this.defaultCurrencyTimeLimit;
    }

    public void setUseStrictCasing(boolean useStrictCasing) {
        this.useStrictCasing = useStrictCasing;
    }

    protected boolean isUseStrictCasing() {
        return this.useStrictCasing;
    }

    protected ModelMBeanAttributeInfo[] getAttributeInfo(String beanKey, Class beanClass) throws JMException {
        PropertyDescriptor[] props = BeanUtils.getPropertyDescriptors(beanClass);
        ArrayList<ModelMBeanAttributeInfo> infos = new ArrayList<ModelMBeanAttributeInfo>();
        for (int i = 0; i < props.length; ++i) {
            Method setter;
            Method getter = props[i].getReadMethod();
            if (getter != null && getter.getDeclaringClass() == (class$java$lang$Object == null ? AbstractReflectiveMBeanInfoAssembler.class$("java.lang.Object") : class$java$lang$Object)) continue;
            if (getter != null && !this.includeReadAttribute(getter, beanKey)) {
                getter = null;
            }
            if ((setter = props[i].getWriteMethod()) != null && !this.includeWriteAttribute(setter, beanKey)) {
                setter = null;
            }
            if (getter == null && setter == null) continue;
            String attributeName = JmxUtils.getAttributeName(props[i], this.isUseStrictCasing());
            ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(attributeName, this.getAttributeDescription(props[i]), getter, setter);
            Descriptor desc = info.getDescriptor();
            if (getter != null) {
                desc.setField("getMethod", getter.getName());
            }
            if (setter != null) {
                desc.setField("setMethod", setter.getName());
            }
            this.populateAttributeDescriptor(desc, getter, setter);
            info.setDescriptor(desc);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanAttributeInfo[infos.size()]);
    }

    protected ModelMBeanOperationInfo[] getOperationInfo(String beanKey, Class beanClass) {
        Method[] methods = beanClass.getMethods();
        ArrayList<ModelMBeanOperationInfo> infos = new ArrayList<ModelMBeanOperationInfo>();
        for (int i = 0; i < methods.length; ++i) {
            Descriptor desc;
            Method method = methods[i];
            ModelMBeanOperationInfo info = null;
            if (method.getDeclaringClass() == (class$java$lang$Object == null ? AbstractReflectiveMBeanInfoAssembler.class$("java.lang.Object") : class$java$lang$Object)) continue;
            PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
            if (pd != null) {
                if (method.equals(pd.getReadMethod()) && this.includeReadAttribute(method, beanKey) || method.equals(pd.getWriteMethod()) && this.includeWriteAttribute(method, beanKey)) {
                    info = this.createModelMBeanOperationInfo(method, pd.getName());
                    desc = info.getDescriptor();
                    desc.setField(VISIBILITY, ATTRIBUTE_OPERATION_VISIBILITY);
                    desc.setField("class", beanClass.getName());
                    if (method.equals(pd.getReadMethod())) {
                        desc.setField(ROLE, GETTER);
                    } else {
                        desc.setField(ROLE, SETTER);
                    }
                    info.setDescriptor(desc);
                }
            } else if (this.includeOperation(method, beanKey)) {
                info = this.createModelMBeanOperationInfo(method, method.getName());
                desc = info.getDescriptor();
                desc.setField(ROLE, OPERATION);
                desc.setField("class", beanClass.getName());
                this.populateOperationDescriptor(desc, method);
                info.setDescriptor(desc);
            }
            if (info == null) continue;
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanOperationInfo[infos.size()]);
    }

    private ModelMBeanOperationInfo createModelMBeanOperationInfo(Method method, String name) {
        MBeanParameterInfo[] params = this.getOperationParameters(method);
        if (params.length == 0) {
            return new ModelMBeanOperationInfo(this.getOperationDescription(method), method);
        }
        return new ModelMBeanOperationInfo(name, this.getOperationDescription(method), this.getOperationParameters(method), method.getReturnType().getName(), 3);
    }

    protected ModelMBeanConstructorInfo[] getConstructorInfo(String beanKey, Class beanClass) {
        return new ModelMBeanConstructorInfo[0];
    }

    protected ModelMBeanNotificationInfo[] getNotificationInfo(String beanKey, Class beanClass) {
        return new ModelMBeanNotificationInfo[0];
    }

    protected MBeanParameterInfo[] getOperationParameters(Method method) {
        return new MBeanParameterInfo[0];
    }

    protected abstract boolean includeReadAttribute(Method var1, String var2);

    protected abstract boolean includeWriteAttribute(Method var1, String var2);

    protected abstract boolean includeOperation(Method var1, String var2);

    protected String getAttributeDescription(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getDisplayName();
    }

    protected String getOperationDescription(Method method) {
        return method.getName();
    }

    protected void populateMBeanDescriptor(Descriptor descriptor, String beanKey, Class beanClass) throws JMException {
        this.applyDefaultCurrencyTimeLimit(descriptor);
    }

    protected void populateAttributeDescriptor(Descriptor descriptor, Method getter, Method setter) {
        this.applyDefaultCurrencyTimeLimit(descriptor);
    }

    protected void populateOperationDescriptor(Descriptor descriptor, Method method) {
        this.applyDefaultCurrencyTimeLimit(descriptor);
    }

    protected final void applyDefaultCurrencyTimeLimit(Descriptor descriptor) {
        if (this.getDefaultCurrencyTimeLimit() != null) {
            descriptor.setField(CURRENCY_TIME_LIMIT, this.getDefaultCurrencyTimeLimit().toString());
        }
    }

    protected void applyCurrencyTimeLimit(Descriptor descriptor, int currencyTimeLimit) {
        if (currencyTimeLimit > 0) {
            descriptor.setField(CURRENCY_TIME_LIMIT, Integer.toString(currencyTimeLimit));
        } else if (currencyTimeLimit == 0) {
            descriptor.setField(CURRENCY_TIME_LIMIT, Integer.toString(Integer.MAX_VALUE));
        } else {
            this.applyDefaultCurrencyTimeLimit(descriptor);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

