/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.transaction.TransactionSystemException;

public class WebLogicServerTransactionManagerFactoryBean
implements FactoryBean {
    private static final String TX_HELPER_CLASS_NAME = "weblogic.transaction.TxHelper";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final TransactionManager transactionManager;

    public WebLogicServerTransactionManagerFactoryBean() throws TransactionSystemException {
        Class<?> clazz;
        try {
            this.logger.debug((Object)"Looking for WebLogic TxHelper: weblogic.transaction.TxHelper");
            clazz = Class.forName(TX_HELPER_CLASS_NAME);
            this.logger.info((Object)("Found WebLogic TxHelper: " + clazz.getName()));
        }
        catch (ClassNotFoundException ex) {
            this.logger.debug((Object)"Could not find WebLogic TxHelper class", (Throwable)ex);
            throw new TransactionSystemException("Couldn't find WebLogic TxHelper class");
        }
        try {
            Method method = clazz.getMethod("getTransactionManager", null);
            this.transactionManager = (TransactionManager)method.invoke(null, (Object[])null);
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Found WebLogic TxHelper class [" + clazz.getName() + "], but couldn't invoke its static 'getTransactionManager' method", ex);
        }
    }

    public Object getObject() {
        return this.transactionManager;
    }

    public Class getObjectType() {
        return this.transactionManager.getClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

