/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.util.Arrays;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AopProxyUtils {
    static /* synthetic */ Class class$org$springframework$aop$SpringProxy;
    static /* synthetic */ Class class$org$springframework$aop$framework$Advised;

    public static Class getTargetClass(Object proxy) {
        Assert.notNull(proxy, "Proxy must not be null");
        if (AopUtils.isCglibProxy(proxy)) {
            return proxy.getClass().getSuperclass();
        }
        if (proxy instanceof Advised) {
            return ((Advised)proxy).getTargetSource().getTargetClass();
        }
        return proxy.getClass();
    }

    public static Class[] completeProxiedInterfaces(AdvisedSupport advised) {
        boolean addSpringProxy;
        Class[] specifiedInterfaces = advised.getProxiedInterfaces();
        boolean bl = addSpringProxy = !advised.isInterfaceProxied(class$org$springframework$aop$SpringProxy == null ? (class$org$springframework$aop$SpringProxy = AopProxyUtils.class$("org.springframework.aop.SpringProxy")) : class$org$springframework$aop$SpringProxy);
        boolean addAdvised = !advised.isOpaque() && !advised.isInterfaceProxied(class$org$springframework$aop$framework$Advised == null ? (class$org$springframework$aop$framework$Advised = AopProxyUtils.class$("org.springframework.aop.framework.Advised")) : class$org$springframework$aop$framework$Advised);
        int offset = 0;
        if (addSpringProxy && addAdvised) {
            offset = 2;
        } else if (addSpringProxy || addAdvised) {
            offset = 1;
        }
        Class[] proxiedInterfaces = new Class[specifiedInterfaces.length + offset];
        if (addSpringProxy) {
            Class clazz = proxiedInterfaces[0] = class$org$springframework$aop$SpringProxy == null ? (class$org$springframework$aop$SpringProxy = AopProxyUtils.class$("org.springframework.aop.SpringProxy")) : class$org$springframework$aop$SpringProxy;
            if (addAdvised) {
                proxiedInterfaces[1] = class$org$springframework$aop$framework$Advised == null ? (class$org$springframework$aop$framework$Advised = AopProxyUtils.class$("org.springframework.aop.framework.Advised")) : class$org$springframework$aop$framework$Advised;
            }
        } else if (addAdvised) {
            proxiedInterfaces[0] = class$org$springframework$aop$framework$Advised == null ? (class$org$springframework$aop$framework$Advised = AopProxyUtils.class$("org.springframework.aop.framework.Advised")) : class$org$springframework$aop$framework$Advised;
        }
        System.arraycopy(specifiedInterfaces, 0, proxiedInterfaces, offset, specifiedInterfaces.length);
        return proxiedInterfaces;
    }

    public static Class[] proxiedUserInterfaces(Object proxy) {
        Class<?>[] proxyInterfaces = proxy.getClass().getInterfaces();
        boolean isSpringProxy = proxy instanceof SpringProxy;
        boolean isAdvised = proxy instanceof Advised;
        int cut = 0;
        if (isAdvised && isSpringProxy) {
            cut = 2;
        } else if (isAdvised || isSpringProxy) {
            cut = 1;
        }
        Object[] beanInterfaces = new Class[proxyInterfaces.length - cut];
        System.arraycopy(proxyInterfaces, cut, beanInterfaces, 0, beanInterfaces.length);
        Assert.notEmpty(beanInterfaces, "JDK proxy must have one or more interface.");
        return beanInterfaces;
    }

    public static boolean equalsInProxy(AdvisedSupport a, AdvisedSupport b) {
        if (a == b) {
            return true;
        }
        return AopProxyUtils.equalsProxiedInterfaces(a, b) && AopProxyUtils.equalsAdvisors(a, b) && ObjectUtils.nullSafeEquals(a.getTargetSource(), b.getTargetSource());
    }

    public static boolean equalsProxiedInterfaces(AdvisedSupport a, AdvisedSupport b) {
        return Arrays.equals(a.getProxiedInterfaces(), b.getProxiedInterfaces());
    }

    public static boolean equalsAdvisors(AdvisedSupport a, AdvisedSupport b) {
        return Arrays.equals(a.getAdvisors(), b.getAdvisors());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

