/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.support;

import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;

public class ArgumentConvertingMethodInvoker
extends MethodInvoker {
    private TypeConverter typeConverter;
    private boolean useDefaultConverter = true;

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
        this.useDefaultConverter = false;
    }

    public TypeConverter getTypeConverter() {
        if (this.typeConverter == null && this.useDefaultConverter) {
            this.typeConverter = this.getDefaultTypeConverter();
        }
        return this.typeConverter;
    }

    protected TypeConverter getDefaultTypeConverter() {
        return new SimpleTypeConverter();
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        TypeConverter converter = this.getTypeConverter();
        if (!(converter instanceof PropertyEditorRegistry)) {
            throw new IllegalStateException("TypeConverter does not implement PropertyEditorRegistry interface: " + converter);
        }
        ((PropertyEditorRegistry)((Object)converter)).registerCustomEditor(requiredType, propertyEditor);
    }

    protected Method findMatchingMethod() {
        Method[] candidates = this.getTargetClass().getMethods();
        Object[] arguments = this.getArguments();
        int argCount = arguments.length;
        for (int i = 0; i < candidates.length; ++i) {
            Class<?>[] paramTypes;
            if (!candidates[i].getName().equals(this.getTargetMethod()) || (paramTypes = candidates[i].getParameterTypes()).length != argCount) continue;
            int numberOfCorrectArguments = 0;
            for (int j = 0; j < argCount; ++j) {
                if (!ClassUtils.isAssignableValue(paramTypes[j], arguments[j])) continue;
                ++numberOfCorrectArguments;
            }
            if (numberOfCorrectArguments != argCount) continue;
            return candidates[i];
        }
        TypeConverter converter = this.getTypeConverter();
        if (converter != null) {
            for (int i = 0; i < candidates.length; ++i) {
                Class<?>[] paramTypes;
                if (!candidates[i].getName().equals(this.getTargetMethod()) || (paramTypes = candidates[i].getParameterTypes()).length != argCount) continue;
                Object[] argumentsToUse = new Object[argCount];
                int numberOfCorrectArguments = 0;
                for (int j = 0; j < argCount; ++j) {
                    try {
                        argumentsToUse[j] = converter.convertIfNecessary(arguments[j], paramTypes[j]);
                        ++numberOfCorrectArguments;
                        continue;
                    }
                    catch (TypeMismatchException ex) {
                        // empty catch block
                    }
                }
                if (numberOfCorrectArguments != argumentsToUse.length) continue;
                this.setArguments(argumentsToUse);
                return candidates[i];
            }
        }
        return null;
    }
}

