/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.ReflectionUtils;

public abstract class AnnotationBeanUtils {
    public static void copyPropertiesToBean(Annotation ann, Object bean, String ... excludedProperties) {
        HashSet<String> excluded = new HashSet<String>(Arrays.asList(excludedProperties));
        Method[] annotationProperties = ann.annotationType().getDeclaredMethods();
        BeanWrapperImpl bw = new BeanWrapperImpl(bean);
        for (Method annotationProperty : annotationProperties) {
            String propertyName = annotationProperty.getName();
            if (excluded.contains(propertyName) || !bw.isWritableProperty(propertyName)) continue;
            Object value = ReflectionUtils.invokeMethod(annotationProperty, ann);
            bw.setPropertyValue(propertyName, value);
        }
    }
}

