/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.Constants;
import org.springsource.loaded.CurrentLiveVersion;
import org.springsource.loaded.FieldMember;
import org.springsource.loaded.FieldReaderWriter;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.InterfaceExtractor;
import org.springsource.loaded.MethodInvokerRewriter;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.ReflectionFieldReaderWriter;
import org.springsource.loaded.ReloadException;
import org.springsource.loaded.TypeDelta;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.TypeDiffComputer;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.TypeRewriter;
import org.springsource.loaded.Utils;
import org.springsource.loaded.__DynamicallyDispatchable;
import org.springsource.loaded.agent.CglibPluginCapturing;
import org.springsource.loaded.infra.UsedByGeneratedCode;
import org.springsource.loaded.ri.Invoker;
import org.springsource.loaded.ri.JavaMethodCache;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.ClassWriter;
import sun.misc.ProxyGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadableType {
    private static Logger log = Logger.getLogger(ReloadableType.class.getName());
    public TypeRegistry typeRegistry;
    public final String dottedtypename;
    public final String slashedtypename;
    private int id;
    public byte[] bytesInitial;
    public byte[] bytesLoaded;
    public final byte[] interfaceBytes;
    public TypeDescriptor typedescriptor;
    private CurrentLiveVersion liveVersion;
    private Class<?> clazz;
    private Class<?> superclazz;
    private ReloadableType superRtype;
    private ReloadableType[] interfaceRtypes;
    List<Reference<ReloadableType>> associatedSubtypes = null;
    private JavaMethodCache javaMethodCache;
    private static final int IS_RESOLVED = 1;
    private static final int IMPACTED_BY_RELOAD = 2;
    private int bits;
    public List<Invoker> invokersCache_getDeclaredMethods = null;
    public Collection<Invoker> invokersCache_getMethods = null;
    public Map<String, Map<String, Invoker>> invokerCache_getMethod = new HashMap<String, Map<String, Invoker>>();
    public Map<String, Map<String, Invoker>> invokerCache_getDeclaredMethod = new HashMap<String, Map<String, Invoker>>();
    public static final ReloadableType NOT_RELOADABLE_TYPE = new ReloadableType();
    public static final WeakReference<ReloadableType> NOT_RELOADABLE_TYPE_REF = new WeakReference<ReloadableType>(NOT_RELOADABLE_TYPE);
    private boolean determinedNeedToRetransform = false;
    private boolean retransformNecessary = false;
    private Object retransformWeavingTransformer;
    private Method retransformWeavingTransformMethod;
    Object[] reflectiveTargets;
    private static final int INDEX_SWAPINIT_METHOD = 0;
    private static final int INDEX_CALLSITEARRAY_FIELD = 1;
    private static final int INDEX_METACLASS_FIELD = 2;
    private Set<WeakReference<Object>> liveInstances = Collections.synchronizedSet(new HashSet());
    private ReferenceQueue<Object> liveInstancesRQ = new ReferenceQueue();
    public Reference<Method[]> jlClassGetDeclaredMethods_cache = new WeakReference<Object>(null);
    public Reference<Method[]> jlClassGetMethods_cache = new WeakReference<Object>(null);

    public Class<?> getClazz() {
        if (this.clazz == null) {
            try {
                this.clazz = Class.forName(this.dottedtypename, false, this.typeRegistry.getClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                throw new ReloadException("Unexpectedly unable to find class " + this.dottedtypename + ".  Asked classloader " + this.typeRegistry.getClassLoader(), cnfe);
            }
        }
        return this.clazz;
    }

    public String toString() {
        return this.dottedtypename;
    }

    public ReloadableType(String dottedtypename, byte[] initialBytes, int id, TypeRegistry typeRegistry, TypeDescriptor typeDescriptor) {
        if (GlobalConfiguration.assertsMode) {
            Utils.assertDotted(dottedtypename);
        }
        this.id = id;
        if (GlobalConfiguration.verboseMode && log.isLoggable(Level.INFO)) {
            log.info("New reloadable type: " + dottedtypename + " (allocatedId=" + id + ") " + typeRegistry.toString());
        }
        this.typeRegistry = typeRegistry;
        this.dottedtypename = dottedtypename;
        this.slashedtypename = dottedtypename.replace('.', '/');
        this.typedescriptor = typeDescriptor != null ? typeDescriptor : typeRegistry.getExtractor().extract(initialBytes, true);
        this.interfaceBytes = InterfaceExtractor.extract(initialBytes, typeRegistry, this.typedescriptor);
        this.bytesInitial = initialBytes;
        this.rewriteCallSitesAndDefine();
    }

    private ReloadableType() {
        this.slashedtypename = null;
        this.dottedtypename = null;
        this.interfaceBytes = null;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.typedescriptor;
    }

    public MethodMember getMethod(String name, String descriptor) {
        for (MethodMember method : this.typedescriptor.getMethods()) {
            if (!method.getName().equals(name) || !method.getDescriptor().equals(descriptor)) continue;
            return method;
        }
        throw new IllegalStateException("Unable to find member '" + name + descriptor + "' on type " + this.dottedtypename);
    }

    public MethodMember getConstructor(String descriptor) {
        for (MethodMember ctor : this.typedescriptor.getConstructors()) {
            if (!ctor.getDescriptor().equals(descriptor)) continue;
            return ctor;
        }
        throw new IllegalStateException("Unable to find constructor '<init>" + descriptor + "' on type " + this.dottedtypename);
    }

    private byte[] retransform(byte[] bytes) {
        block10: {
            if (!this.determinedNeedToRetransform) {
                try {
                    String s = System.getProperty("insight.enabled", "false");
                    if (s.equals("true")) {
                        ClassLoader cl = this.typeRegistry.getClassLoader();
                        Field f = cl.getClass().getSuperclass().getDeclaredField("weavingTransformer");
                        if (f != null) {
                            f.setAccessible(true);
                            this.retransformWeavingTransformer = f.get(cl);
                            this.retransformWeavingTransformMethod = this.retransformWeavingTransformer.getClass().getDeclaredMethod("transformIfNecessary", String.class, byte[].class);
                            this.retransformNecessary = true;
                        }
                        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                            log.info("Determining if retransform necessary, result = " + this.retransformNecessary);
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Unexpected exception when determining if Spring Insight enabled", e);
                    this.retransformNecessary = false;
                }
                this.determinedNeedToRetransform = true;
            }
            if (this.retransformNecessary) {
                try {
                    this.retransformWeavingTransformMethod.setAccessible(true);
                    byte[] newdata = (byte[])this.retransformWeavingTransformMethod.invoke(this.retransformWeavingTransformer, this.slashedtypename, bytes);
                    if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                        log.info("retransform was attempted, oldsize=" + bytes.length + " newsize=" + newdata.length);
                    }
                    return newdata;
                }
                catch (Exception e) {
                    if (!GlobalConfiguration.isRuntimeLogging) break block10;
                    log.log(Level.SEVERE, "Unexpected exception when trying to run other weaving transformers", e);
                }
            }
        }
        return bytes;
    }

    public boolean loadNewVersion(byte[] newbytedata) {
        return this.loadNewVersion("2", newbytedata);
    }

    public boolean simulateReload() {
        return this.loadNewVersion("0", this.bytesInitial);
    }

    public boolean loadNewVersion(String versionsuffix, byte[] newbytedata, boolean shouldRerunStaticInitializer) {
        boolean reloadedOK = this.loadNewVersion(versionsuffix, newbytedata);
        if (reloadedOK) {
            this.runStaticInitializer();
        }
        return reloadedOK;
    }

    public boolean loadNewVersion(String versionsuffix, byte[] newbytedata) {
        this.javaMethodCache = null;
        if (GlobalConfiguration.verboseMode && log.isLoggable(Level.INFO)) {
            log.info("Loading new version of " + this.slashedtypename + ", identifying suffix " + versionsuffix + ", new data length is " + newbytedata.length + "bytes");
        }
        newbytedata = this.retransform(newbytedata);
        boolean reload = true;
        TypeDelta td = null;
        if (GlobalConfiguration.verifyReloads && (td = TypeDiffComputer.computeDifferences(this.bytesInitial, newbytedata)).hasAnythingChanged()) {
            boolean cantReload = false;
            StringBuilder s = null;
            if (td.hasTypeDeclarationChanged()) {
                reload = false;
                s = new StringBuilder("Spring Loaded: Cannot reload new version of ").append(this.dottedtypename).append("\n");
                if (td.hasTypeAccessChanged()) {
                    s.append(" Reason: Type modifiers changed\n");
                    cantReload = true;
                }
                if (td.hasTypeSupertypeChanged()) {
                    s.append(" Reason: Supertype changed from ").append(td.oSuperName).append(" to ").append(td.nSuperName).append("\n");
                    cantReload = true;
                }
                if (td.hasTypeInterfacesChanged()) {
                    boolean justGroovyObjectMoved = false;
                    if (!cantReload && this.getTypeDescriptor().isGroovyType()) {
                        ArrayList<String> interfaceChanges = new ArrayList<String>();
                        interfaceChanges.addAll(td.oInterfaces);
                        interfaceChanges.removeAll(td.nInterfaces);
                        if (this.getTypeDescriptor().isGroovyType() && interfaceChanges.size() == 1 && ((String)interfaceChanges.get(0)).equals("groovy/lang/GroovyObject")) {
                            justGroovyObjectMoved = true;
                            s = null;
                            reload = true;
                        }
                    }
                    if (!justGroovyObjectMoved) {
                        s.append(" Reason: Interfaces changed from ").append(td.oInterfaces).append(" to ").append(td.nInterfaces).append("\n");
                        cantReload = true;
                    }
                }
            }
            boolean somethingCalled = false;
            if (cantReload && td.hasAnythingChanged()) {
                somethingCalled = this.typeRegistry.fireUnableToReloadEvent(this, td, versionsuffix);
            }
            if (cantReload && s == null && td.hasAnythingChanged() && !somethingCalled) {
                System.out.println("Something has changed preventing reload");
            }
            if (!somethingCalled && s != null) {
                System.out.println(s);
            }
        }
        if (reload) {
            TypeRegistry.nothingReloaded = false;
            this.invokersCache_getDeclaredMethods = null;
            if (GlobalConfiguration.reloadMessages) {
                System.out.println("Reloading: Loading new version of " + this.dottedtypename + " [" + versionsuffix + "]");
            }
            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                log.info("Reloading: Loading new version of " + this.dottedtypename + " [" + versionsuffix + "]");
            }
            this.liveVersion = new CurrentLiveVersion(this, versionsuffix, newbytedata);
            this.liveVersion.setTypeDelta(td);
            this.typeRegistry.reloadableTypeDescriptorCache.put(this.slashedtypename, this.liveVersion.typeDescriptor);
            if (this.typedescriptor.isGroovyType()) {
                this.fixupGroovyType();
            }
            if (this.typedescriptor.isEnum()) {
                this.resetEnumRelatedState();
            }
            if (this.typeRegistry.shouldRerunStaticInitializer(this, versionsuffix) || this.typedescriptor.isEnum()) {
                this.liveVersion.staticInitializedNeedsRerunningOnDefine = true;
                this.liveVersion.runStaticInitializer();
            } else {
                this.liveVersion.staticInitializedNeedsRerunningOnDefine = false;
            }
            this.tagAsAffectedByReload();
            this.tagSupertypesAsAffectedByReload();
            this.tagSubtypesAsAffectedByReload();
            this.typeRegistry.fireReloadEvent(this, versionsuffix);
            this.reloadProxiesIfNecessary(versionsuffix);
        }
        return reload;
    }

    private void tagSupertypesAsAffectedByReload() {
        ReloadableType[] superinterfaceRtypes;
        ReloadableType superRtype = this.getSuperRtype();
        if (superRtype != null) {
            superRtype.tagAsAffectedByReload();
            superRtype.tagSupertypesAsAffectedByReload();
        }
        if ((superinterfaceRtypes = this.getInterfacesRtypes()) != null) {
            for (ReloadableType superinterfaceRtype : superinterfaceRtypes) {
                superinterfaceRtype.tagAsAffectedByReload();
                superinterfaceRtype.tagSupertypesAsAffectedByReload();
            }
        }
    }

    private void tagSubtypesAsAffectedByReload() {
        if (this.associatedSubtypes != null) {
            for (Reference<ReloadableType> ref : this.associatedSubtypes) {
                ReloadableType rsubtype = ref.get();
                if (rsubtype == null) continue;
                rsubtype.tagAsAffectedByReload();
                rsubtype.tagSubtypesAsAffectedByReload();
            }
        }
    }

    private void tagAsAffectedByReload() {
        this.bits |= 2;
        this.invokersCache_getMethods = null;
        this.invokersCache_getDeclaredMethods = null;
    }

    public boolean isAffectedByReload() {
        return (this.bits & 2) != 0;
    }

    private void resetEnumRelatedState() {
        Field f;
        if (this.clazz == null) {
            return;
        }
        try {
            f = this.clazz.getClass().getDeclaredField("enumConstants");
            f.setAccessible(true);
            f.set(this.clazz, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            f = this.clazz.getClass().getDeclaredField("enumConstantDirectory");
            f.setAccessible(true);
            f.set(this.clazz, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dump(byte[] newbytedata) {
        String slashedName = this.getSlashedName();
        if (slashedName.contains("BookController")) {
            GlobalConfiguration.dumpFolder = "/Users/aclement/Downloads/grails8344";
            Utils.dump(slashedName + "O", this.bytesInitial);
            Utils.dump(slashedName + "L", this.bytesLoaded);
            Utils.dump(slashedName + "N", newbytedata);
            Utils.dump(slashedName + "E", this.liveVersion.executor);
            Utils.dump(slashedName + "D", this.liveVersion.dispatcher);
        }
    }

    private void reloadProxiesIfNecessary(String versionsuffix) {
        Method found;
        Method[] ms;
        Object b;
        Object a;
        ReloadableType proxy = this.typeRegistry.cglibProxies.get(this.slashedtypename);
        if (proxy != null) {
            Object[] strategyAndGeneratorPair = CglibPluginCapturing.clazzToGeneratorStrategyAndClassGeneratorMap.get(this.getClazz());
            if (strategyAndGeneratorPair == null) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.severe("Unable to find regeneration methods for cglib proxies - proxies will be out of date for this type");
                }
                return;
            }
            a = strategyAndGeneratorPair[0];
            b = strategyAndGeneratorPair[1];
            try {
                ms = a.getClass().getMethods();
                found = null;
                for (Method m : ms) {
                    if (!m.getName().equals("generate")) continue;
                    found = m;
                    break;
                }
                byte[] byArray = (byte[])found.invoke(a, b);
                proxy.loadNewVersion(versionsuffix, byArray);
                proxy.runStaticInitializer();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if ((proxy = this.typeRegistry.cglibProxiesFastClass.get(this.slashedtypename)) != null) {
            Object[] strategyAndFCGeneratorPair = CglibPluginCapturing.clazzToGeneratorStrategyAndFastClassGeneratorMap.get(this.getClazz());
            strategyAndFCGeneratorPair = CglibPluginCapturing.clazzToGeneratorStrategyAndFastClassGeneratorMap.get(this.getClazz());
            if (strategyAndFCGeneratorPair != null) {
                a = strategyAndFCGeneratorPair[0];
                b = strategyAndFCGeneratorPair[1];
                try {
                    ms = a.getClass().getMethods();
                    found = null;
                    for (Method m : ms) {
                        if (!m.getName().equals("generate")) continue;
                        found = m;
                        break;
                    }
                    byte[] byArray = (byte[])found.invoke(a, b);
                    proxy.loadNewVersion(versionsuffix, byArray);
                    proxy.runStaticInitializer();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        try {
            Set<ReloadableType> relevantProxies;
            if (this.clazz.isInterface() && (relevantProxies = this.typeRegistry.jdkProxiesForInterface.get(this.slashedtypename)) != null) {
                for (ReloadableType relevantProxy : relevantProxies) {
                    Class[] interfacesImplementedByProxy = relevantProxy.getClazz().getInterfaces();
                    byte[] newProxyBytes = ProxyGenerator.generateProxyClass((String)relevantProxy.getSlashedName(), (Class[])interfacesImplementedByProxy);
                    relevantProxy.loadNewVersion(versionsuffix, newProxyBytes, true);
                }
            }
        }
        catch (Throwable t) {
            new RuntimeException("Unexpected problem trying to reload proxy for interface " + this.dottedtypename, t).printStackTrace();
        }
    }

    public void fixupGroovyType() {
        Field f;
        StringBuilder s = new StringBuilder();
        if (this.reflectiveTargets == null) {
            this.reflectiveTargets = new Object[5];
            try {
                this.reflectiveTargets[0] = this.clazz.getDeclaredMethod("__$swapInit", new Class[0]);
            }
            catch (Exception e) {
                s.append("cannot discover __$swapInit " + e.toString() + "  --  ");
            }
            try {
                this.reflectiveTargets[1] = this.clazz.getDeclaredField("$callSiteArray");
            }
            catch (Exception e) {
                s.append("cannot discover $callSiteArray " + e.toString() + "  --  ");
            }
            try {
                this.reflectiveTargets[2] = this.clazz.getDeclaredField("$class$groovy$lang$MetaClass");
            }
            catch (Exception e) {
                s.append("cannot discover $class$groovy$lang$MetaClass " + e.toString() + "  --  ");
            }
            try {
                this.reflectiveTargets[3] = this.clazz.getDeclaredField("$staticClassInfo");
            }
            catch (Exception e) {
                s.append("cannot discover $staticClassInfo " + e.toString() + "  --  ");
            }
        }
        try {
            Method m = null;
            f = null;
            if (this.reflectiveTargets[0] != null) {
                m = (Method)this.reflectiveTargets[0];
                m.setAccessible(true);
                m.invoke(null, new Object[0]);
            }
            if (this.reflectiveTargets[1] != null) {
                f = (Field)this.reflectiveTargets[1];
                f.setAccessible(true);
                f.set(null, null);
            }
            if (this.reflectiveTargets[2] != null) {
                f = (Field)this.reflectiveTargets[2];
                f.setAccessible(true);
                f.set(null, null);
            }
            if (this.reflectiveTargets[3] != null) {
                f = (Field)this.reflectiveTargets[3];
                f.setAccessible(true);
                f.set(null, null);
            }
        }
        catch (Exception e) {
            s.append("cannot reset state" + e.toString() + "  --  ");
        }
        try {
            Class<?> clazz = this.typeRegistry.getClass_GroovySystem();
            Field metaClassRegistryField = clazz.getDeclaredField("META_CLASS_REGISTRY");
            metaClassRegistryField.setAccessible(true);
            Object metaClassRegistry = metaClassRegistryField.get(null);
            Method metaClassRegistryMethod = metaClassRegistry.getClass().getDeclaredMethod("removeMetaClass", Class.class);
            metaClassRegistryMethod.setAccessible(true);
            metaClassRegistryMethod.invoke(metaClassRegistry, this.getClazz());
        }
        catch (Exception e) {
            s.append("Unable to remove meta class for groovy type " + this.dottedtypename + ": " + e.toString() + "  --  ");
        }
        try {
            Method getClassInfoMethod = this.typeRegistry.getMethod_ClassInfo_getClassInfo();
            Object classInfoObject = getClassInfoMethod.invoke(null, this.clazz);
            Field cachedClassRefField = this.typeRegistry.getField_ClassInfo_cachedClassRef();
            cachedClassRefField.setAccessible(true);
            Object cachedClassRefObject = cachedClassRefField.get(classInfoObject);
            Class<?> lazyReferenceClass = cachedClassRefObject.getClass();
            Method clearMethod = lazyReferenceClass.getMethod("clear", new Class[0]);
            clearMethod.invoke(cachedClassRefObject, new Object[0]);
        }
        catch (Exception e) {
            s.append("1 Unable to clear ClassInfo CachedClass data for groovy type " + this.dottedtypename + ": " + e.toString() + "  --  ");
        }
        try {
            Class<?> class_ClassInfo = this.typeRegistry.getClass_ClassInfo();
            Field field_globalClassSet = class_ClassInfo.getDeclaredField("globalClassSet");
            field_globalClassSet.setAccessible(true);
            Object instance_classInfoSet = field_globalClassSet.get(null);
            Method method_ClassInfoSetRemove = instance_classInfoSet.getClass().getMethod("remove", Object.class);
            Object retval = method_ClassInfoSetRemove.invoke(instance_classInfoSet, this.clazz);
        }
        catch (Exception e) {
            s.append("2 Unable to clear ClassInfo CachedClass data for groovy type " + this.dottedtypename + ": " + e.toString() + "  --  ");
        }
        try {
            HashSet<WeakReference<Object>> deadInstances = null;
            f = this.getClazz().getDeclaredField("metaClass");
            for (WeakReference<Object> instance : this.liveInstances) {
                Object o = instance.get();
                if (o == null) {
                    if (deadInstances == null) {
                        deadInstances = new HashSet<WeakReference<Object>>();
                    }
                    deadInstances.add(instance);
                    continue;
                }
                f.setAccessible(true);
                f.set(o, null);
            }
            if (deadInstances != null) {
                this.liveInstances.removeAll(deadInstances);
            }
        }
        catch (Exception e) {
            s.append("2 Unable to clear metaClass for groovy object instance (class=" + this.dottedtypename + ") " + e.toString() + "  --  ");
        }
    }

    public byte[] getLatestDispatcherBytes() {
        return this.liveVersion == null ? null : this.liveVersion.dispatcher;
    }

    public Class<?> getLatestDispatcherClass() {
        return this.liveVersion == null ? null : this.liveVersion.dispatcherClass;
    }

    public byte[] getInterfaceBytes() {
        return this.interfaceBytes;
    }

    public Object getLatestDispatcherInstance() {
        return this.liveVersion == null ? null : this.liveVersion.dispatcherInstance;
    }

    public Object getLatestDispatcherInstance(boolean b) {
        if (b) {
            if (this.liveVersion == null) {
                this.loadNewVersion("0", this.bytesInitial);
            }
            return this.liveVersion.dispatcherInstance;
        }
        return this.liveVersion == null ? null : this.liveVersion.dispatcherInstance;
    }

    public String getLatestDispatcherName() {
        return this.liveVersion == null ? null : this.liveVersion.dispatcherName;
    }

    public byte[] getBytesInitial() {
        return this.bytesInitial;
    }

    public byte[] getBytesLoaded() {
        return this.bytesLoaded;
    }

    public byte[] getLatestExecutorBytes() {
        return this.liveVersion == null ? null : this.liveVersion.executor;
    }

    public Class<?> getLatestExecutorClass() {
        return this.liveVersion == null ? null : this.liveVersion.getExecutorClass();
    }

    public String getLatestExecutorName() {
        return this.liveVersion == null ? null : this.liveVersion.executorName;
    }

    public MethodMember getCurrentMethod(String name, String descriptor) {
        if (this.liveVersion == null) {
            return this.getMethod(name, descriptor);
        }
        return this.liveVersion.getReloadableMethod(name, descriptor);
    }

    public MethodMember getOriginalMethod(String nameAndDescriptor) {
        return this.getMethod(nameAndDescriptor);
    }

    public String getName() {
        return this.dottedtypename;
    }

    public String getSlashedName() {
        return this.slashedtypename;
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public int getTypeRegistryId() {
        return this.typeRegistry.getId();
    }

    public int getId() {
        return this.id;
    }

    public void rewriteCallSitesAndDefine() {
        this.bytesLoaded = MergedRewrite.rewrite(this, this.bytesInitial);
        if (!this.typedescriptor.isInterface()) {
            this.typeRegistry.defineClass(Utils.getInterfaceName(this.dottedtypename), this.interfaceBytes, true);
        }
        if (this.typeRegistry.shouldDefineClasses()) {
            this.clazz = this.typeRegistry.defineClass(this.dottedtypename, this.bytesLoaded, true);
        }
    }

    public Object fetchLatest() {
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "fetchLatest called on " + this.getName());
        }
        return this.liveVersion.dispatcherInstance;
    }

    public boolean hasBeenReloaded() {
        return this.liveVersion != null;
    }

    public CurrentLiveVersion getLiveVersion() {
        return this.liveVersion;
    }

    public boolean cchanged(String descriptor) {
        if (this.liveVersion != null) {
            boolean b = this.liveVersion.hasConstructorChanged(descriptor);
            return b;
        }
        return false;
    }

    @UsedByGeneratedCode
    public Object cchanged(int ctorId) {
        boolean b;
        if (this.liveVersion != null && (b = this.liveVersion.hasConstructorChanged(ctorId))) {
            return this.getLatestDispatcherInstance();
        }
        return null;
    }

    @UsedByGeneratedCode
    public int changed(int methodId) {
        if (this.liveVersion == null) {
            return 0;
        }
        int retval = 0;
        if (this.liveVersion != null) {
            boolean b;
            if (GlobalConfiguration.logging && log.isLoggable(Level.FINER)) {
                log.info("MethodId=" + methodId + " method=" + this.typedescriptor.getMethod(methodId));
            }
            retval = (b = this.liveVersion.incrementalTypeDescriptor.hasBeenDeleted(methodId)) ? 2 : (this.liveVersion.incrementalTypeDescriptor.mustUseExecutorForThisMethod(methodId) ? 1 : 0);
        }
        return retval;
    }

    @UsedByGeneratedCode
    public int clinitchanged() {
        if (GlobalConfiguration.logging && log.isLoggable(Level.FINER)) {
            log.entering("ReloadableType", "clinitchanged", null);
        }
        int retval = 0;
        if (this.liveVersion != null) {
            int n = retval = this.liveVersion.hasClinit() ? 1 : 0;
        }
        if (GlobalConfiguration.logging && log.isLoggable(Level.FINER)) {
            log.exiting("ReloadableType", "clinitchanged", retval);
        }
        return retval;
    }

    @UsedByGeneratedCode
    public Object fetchLatestIfExists(int methodId) {
        if (TypeRegistry.nothingReloaded) {
            return null;
        }
        if (this.changed(methodId) == 0) {
            return null;
        }
        return this.fetchLatest();
    }

    public String getSlashedSupertypeName() {
        return this.getTypeDescriptor().getSupertypeName();
    }

    public String[] getSlashedSuperinterfacesName() {
        return this.getTypeDescriptor().getSuperinterfacesName();
    }

    @UsedByGeneratedCode
    public __DynamicallyDispatchable getDispatcher() {
        __DynamicallyDispatchable dd = null;
        if (this.liveVersion == null) {
            this.simulateReload();
        }
        dd = (__DynamicallyDispatchable)this.liveVersion.dispatcherInstance;
        return dd;
    }

    @UsedByGeneratedCode
    public __DynamicallyDispatchable determineDispatcher(Object instance, String nameAndDescriptor) {
        if (nameAndDescriptor.startsWith("<init>")) {
            if (!this.hasBeenReloaded()) {
                this.loadNewVersion("0", this.bytesInitial);
            }
            return (__DynamicallyDispatchable)this.getLiveVersion().dispatcherInstance;
        }
        String dynamicTypeName = instance.getClass().getName();
        ReloadableType rtype = this.typeRegistry.getReloadableType(dynamicTypeName.replace('.', '/'));
        if (rtype == null) {
            throw new ReloadException("ReloadableType.determineDispatcher(): expected " + dynamicTypeName + " to be reloadable");
        }
        boolean found = false;
        while (rtype != null && !found) {
            Iterator mms;
            if (rtype.hasBeenReloaded()) {
                mms = rtype.getLiveVersion().incrementalTypeDescriptor.getNewOrChangedMethods();
                Iterator iterator = mms.iterator();
                while (iterator.hasNext()) {
                    MethodMember mm = (MethodMember)iterator.next();
                    if (mm.isPrivate() || !mm.getNameAndDescriptor().equals(nameAndDescriptor)) continue;
                    found = true;
                    break;
                }
            } else {
                for (Object mm : mms = rtype.getTypeDescriptor().getMethods()) {
                    if (!((MethodMember)mm).getNameAndDescriptor().equals(nameAndDescriptor) || MethodMember.isCatcher((MethodMember)mm) || MethodMember.isSuperDispatcher((MethodMember)mm)) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            String slashedSupername = rtype.getTypeDescriptor().getSupertypeName();
            rtype = this.typeRegistry.getReloadableType(slashedSupername);
        }
        if (found && GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "appears that type " + rtype.getName() + " implements " + nameAndDescriptor);
        }
        if (rtype == null) {
            return null;
        }
        if (!rtype.hasBeenReloaded()) {
            rtype.loadNewVersion("0", rtype.bytesInitial);
        }
        return (__DynamicallyDispatchable)rtype.getLiveVersion().dispatcherInstance;
    }

    public String getBaseName() {
        int dotIndex = this.dottedtypename.lastIndexOf(".");
        if (dotIndex == -1) {
            return this.dottedtypename;
        }
        return this.dottedtypename.substring(dotIndex + 1);
    }

    public TypeDescriptor getLatestTypeDescriptor() {
        if (this.liveVersion == null) {
            return this.typedescriptor;
        }
        return this.liveVersion.incrementalTypeDescriptor.getLatestTypeDescriptor();
    }

    public MethodMember getFromLatestByDescriptor(String nameAndDescriptor) {
        return this.getLiveVersion().incrementalTypeDescriptor.getFromLatestByDescriptor(nameAndDescriptor);
    }

    public MethodMember getMethod(String nameAndDescriptor) {
        for (MethodMember method : this.typedescriptor.getMethods()) {
            if (!nameAndDescriptor.startsWith(method.getName()) || !nameAndDescriptor.endsWith(method.getDescriptor())) continue;
            return method;
        }
        return null;
    }

    public MethodMember getCurrentConstructor(String desc) {
        TypeDescriptor typeDesc = this.getLatestTypeDescriptor();
        return typeDesc.getConstructor(desc);
    }

    public MethodMember getOriginalConstructor(String desc) {
        for (MethodMember method : this.typedescriptor.getConstructors()) {
            if (!method.getDescriptor().equals(desc)) continue;
            return method;
        }
        return null;
    }

    public JavaMethodCache getJavaMethodCache() {
        if (this.javaMethodCache == null) {
            this.javaMethodCache = new JavaMethodCache();
        }
        return this.javaMethodCache;
    }

    public FieldMember findInstanceField(String name) {
        FieldMember found = this.getLatestTypeDescriptor().getField(name);
        if (found != null) {
            return found;
        }
        String slashedSupername = this.getTypeDescriptor().getSupertypeName();
        ReloadableType rtype = this.typeRegistry.getReloadableType(slashedSupername);
        while (rtype != null && (found = rtype.getLatestTypeDescriptor().getField(name)) == null) {
            slashedSupername = rtype.getTypeDescriptor().getSupertypeName();
            rtype = this.typeRegistry.getReloadableType(slashedSupername);
        }
        return found;
    }

    public FieldMember findStaticField(String name) {
        return this.searchType(this, name);
    }

    private FieldMember searchType(ReloadableType rtype, String fieldname) {
        if (rtype != null) {
            ReloadableType stype;
            TypeDescriptor td = rtype.getLatestTypeDescriptor();
            FieldMember field = td.getField(fieldname);
            if (field != null) {
                return field;
            }
            String[] interfaces = td.getSuperinterfacesName();
            if (interfaces != null) {
                for (String intface : interfaces) {
                    ReloadableType itype = this.typeRegistry.getReloadableType(intface);
                    if (intface == null || (field = this.searchType(itype, fieldname)) == null) continue;
                    return field;
                }
            }
            if ((stype = this.typeRegistry.getReloadableType(td.getSupertypeName())) != null) {
                return this.searchType(stype, fieldname);
            }
        }
        return null;
    }

    public void setField(Object instance, String fieldname, boolean isStatic, Object newValue) throws IllegalAccessException {
        FieldReaderWriter fieldReaderWriter = this.locateField(fieldname);
        if (isStatic && !fieldReaderWriter.isStatic()) {
            throw new IncompatibleClassChangeError("Expected static field " + fieldReaderWriter.theField.getDeclaringTypeName() + "." + fieldReaderWriter.theField.getName());
        }
        if (!isStatic && fieldReaderWriter.isStatic()) {
            throw new IncompatibleClassChangeError("Expected non-static field " + fieldReaderWriter.theField.getDeclaringTypeName() + "." + fieldReaderWriter.theField.getName());
        }
        if (fieldReaderWriter.isStatic()) {
            fieldReaderWriter.setStaticFieldValue(this.getClazz(), newValue, null);
        } else {
            fieldReaderWriter.setValue(instance, newValue, null);
        }
    }

    public Object getField(Object instance, String fieldname, boolean isStatic) throws IllegalAccessException {
        FieldReaderWriter fieldReaderWriter = this.locateField(fieldname);
        if (isStatic && !fieldReaderWriter.isStatic()) {
            throw new IncompatibleClassChangeError("Expected static field " + fieldReaderWriter.theField.getDeclaringTypeName() + "." + fieldReaderWriter.theField.getName());
        }
        if (!isStatic && fieldReaderWriter.isStatic()) {
            throw new IncompatibleClassChangeError("Expected non-static field " + fieldReaderWriter.theField.getDeclaringTypeName() + "." + fieldReaderWriter.theField.getName());
        }
        Object o = null;
        o = fieldReaderWriter.isStatic() ? fieldReaderWriter.getStaticFieldValue(this.getClazz(), null) : fieldReaderWriter.getValue(instance, null);
        return o;
    }

    public FieldReaderWriter locateField(String name) {
        if (this.hasFieldChangedInHierarchy(name)) {
            return this.walk(name, this.getLatestTypeDescriptor());
        }
        return this.getFieldInHierarchy(name);
    }

    public FieldReaderWriter walk(String name, TypeDescriptor typeDescriptor) {
        String[] superinterfaceNames;
        FieldMember theField = typeDescriptor.getField(name);
        if (theField != null) {
            return new FieldReaderWriter(theField, typeDescriptor);
        }
        for (String superinterfaceName : superinterfaceNames = typeDescriptor.getSuperinterfacesName()) {
            TypeDescriptor interfaceTypeDescriptor = this.getTypeRegistry().getLatestDescriptorFor(superinterfaceName);
            FieldReaderWriter locator = this.walk(name, interfaceTypeDescriptor);
            if (locator == null) continue;
            return locator;
        }
        String supertypename = typeDescriptor.getSupertypeName();
        if (supertypename != null) {
            TypeDescriptor superTypeDescriptor = this.getTypeRegistry().getLatestDescriptorFor(supertypename);
            FieldReaderWriter locator = this.walk(name, superTypeDescriptor);
            return locator;
        }
        return null;
    }

    private FieldWalkDiscoveryResult hasFieldChangedInHierarchy(String fieldname, String slashedName) {
        ReloadableType rtype = this.typeRegistry.getReloadableType(slashedName);
        if (rtype == null) {
            return FieldWalkDiscoveryResult.UNCHANGED_STOPWALKINGNOW;
        }
        TypeDescriptor originalTypeDescriptor = rtype.getTypeDescriptor();
        FieldMember originalField = originalTypeDescriptor.getField(fieldname);
        TypeDescriptor typedescriptor = rtype.getLatestTypeDescriptor();
        FieldMember field = typedescriptor.getField(fieldname);
        if (originalField != null && field == null) {
            return FieldWalkDiscoveryResult.CHANGED_STOPNOW;
        }
        if (originalField != null && field != null) {
            if (originalField.equals(field)) {
                return FieldWalkDiscoveryResult.UNCHANGED_STOPWALKINGNOW;
            }
            return FieldWalkDiscoveryResult.CHANGED_STOPNOW;
        }
        if (originalField == null && field != null) {
            return FieldWalkDiscoveryResult.CHANGED_STOPNOW;
        }
        String[] interfaces = originalTypeDescriptor.superinterfaceNames;
        if (interfaces != null) {
            for (String intface : interfaces) {
                FieldWalkDiscoveryResult b = this.hasFieldChangedInHierarchy(fieldname, intface);
                if (b == FieldWalkDiscoveryResult.DONTKNOW) continue;
                return b;
            }
        }
        return this.hasFieldChangedInHierarchy(fieldname, originalTypeDescriptor.supertypeName);
    }

    public boolean hasFieldChangedInHierarchy(String name) {
        ReloadableType rtype = this;
        FieldMember field = null;
        TypeDescriptor originalTypeDescriptor = rtype.getTypeDescriptor();
        FieldMember originalField = originalTypeDescriptor.getField(name);
        TypeDescriptor typedescriptor = rtype.getLatestTypeDescriptor();
        field = typedescriptor.getField(name);
        if (originalField != null && field == null) {
            return true;
        }
        if (originalField != null && field != null) {
            return !originalField.equals(field);
        }
        if (originalField == null && field != null) {
            return true;
        }
        FieldWalkDiscoveryResult b = this.hasFieldChangedInHierarchy(name, rtype.getTypeDescriptor().getSupertypeName());
        switch (b) {
            case CHANGED_STOPNOW: {
                return true;
            }
            case UNCHANGED_STOPWALKINGNOW: {
                return false;
            }
            case DONTKNOW: {
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    private Field findField(Class<?> clazz, String name) {
        Class<?> supertype;
        AnnotatedElement field = null;
        try {
            Field[] fields = clazz.getDeclaredFields();
            if (fields != null) {
                for (AnnotatedElement annotatedElement : fields) {
                    if (!((Field)annotatedElement).getName().equals(name)) continue;
                    field = annotatedElement;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (field != null) {
            return field;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces != null) {
            for (AnnotatedElement annotatedElement : interfaces) {
                field = this.findField((Class<?>)annotatedElement, name);
                if (field == null) continue;
                return field;
            }
        }
        if ((supertype = clazz.getSuperclass()) != null) {
            return this.findField(supertype, name);
        }
        return null;
    }

    public FieldReaderWriter getFieldInHierarchy(String name) {
        return new ReflectionFieldReaderWriter(this.findField(this.getClazz(), name));
    }

    public void clearClassloaderLinks() {
        if (this.hasBeenReloaded()) {
            this.liveVersion.clearClassloaderLinks();
        }
    }

    public void reloadMostRecentDispatcherAndExecutor() {
        if (this.hasBeenReloaded()) {
            this.liveVersion.reloadMostRecentDispatcherAndExecutor();
        }
    }

    public void trackLiveInstance(Object instance) {
        Reference<Object> r;
        while ((r = this.liveInstancesRQ.poll()) != null) {
            this.liveInstances.remove(r);
        }
        this.liveInstances.add(new WeakReference<Object>(instance, this.liveInstancesRQ));
    }

    public void runStaticInitializer() {
        if (this.hasBeenReloaded()) {
            this.liveVersion.runStaticInitializer();
        }
    }

    public boolean isResolved() {
        return (this.bits & 1) != 0;
    }

    public void setResolved() {
        this.bits |= 1;
    }

    public void setSuperclass(Class<?> superclazz) {
        this.superclazz = superclazz;
    }

    public ReloadableType getSuperRtype() {
        if (this.superRtype != null) {
            return this.superRtype;
        }
        if (this.superclazz == null) {
            ReloadableType rtype;
            String name = this.getSlashedSupertypeName();
            if (name == null) {
                return null;
            }
            this.superRtype = rtype = this.typeRegistry.getReloadableSuperType(name);
            return this.superRtype;
        }
        ClassLoader superClassLoader = this.superclazz.getClassLoader();
        TypeRegistry superTypeRegistry = TypeRegistry.getTypeRegistryFor(superClassLoader);
        this.superRtype = superTypeRegistry.getReloadableType(this.superclazz);
        return this.superRtype;
    }

    public ReloadableType[] getInterfacesRtypes() {
        String[] names;
        if (this.interfaceRtypes != null) {
            return this.interfaceRtypes;
        }
        if (this.getSlashedSuperinterfacesName() == null) {
            return null;
        }
        ArrayList<ReloadableType> reloadableInterfaces = new ArrayList<ReloadableType>();
        for (String name : names = this.getSlashedSuperinterfacesName()) {
            ReloadableType interfaceRtype = this.typeRegistry.getReloadableSuperType(name);
            if (interfaceRtype == null) continue;
            reloadableInterfaces.add(interfaceRtype);
        }
        this.interfaceRtypes = reloadableInterfaces.toArray(new ReloadableType[reloadableInterfaces.size()]);
        return this.interfaceRtypes;
    }

    public boolean hasStaticInitializer() {
        return this.typedescriptor.hasClinit();
    }

    public void recordSubtype(ReloadableType child) {
        if (this.associatedSubtypes == null) {
            this.associatedSubtypes = new ArrayList<Reference<ReloadableType>>();
        }
        this.associatedSubtypes.add(new WeakReference<ReloadableType>(child));
        if (this.isAffectedByReload()) {
            child.tagAsAffectedByReload();
            child.tagSubtypesAsAffectedByReload();
        }
    }

    public List<Reference<ReloadableType>> getAssociatedSubtypes() {
        return this.associatedSubtypes;
    }

    public void createTypeAssociations() {
        ReloadableType[] irtypes;
        ClassLoader classLoader = this.getClazz().getClassLoader();
        if (classLoader == null) {
            return;
        }
        ReloadableType srtype = this.getSuperRtype();
        if (srtype != null) {
            srtype.recordSubtype(this);
        }
        if ((irtypes = this.getInterfacesRtypes()) != null) {
            for (ReloadableType irtype : irtypes) {
                irtype.recordSubtype(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FieldWalkDiscoveryResult {
        CHANGED_STOPNOW,
        UNCHANGED_STOPWALKINGNOW,
        DONTKNOW;

    }

    static class MergedRewrite {
        MergedRewrite() {
        }

        public static byte[] rewrite(ReloadableType rtype, byte[] bytes) {
            try {
                ClassReader fileReader = new ClassReader(bytes);
                ChainedAdapters classAdaptor = new ChainedAdapters(rtype);
                fileReader.accept(classAdaptor, 0);
                return classAdaptor.getBytes();
            }
            catch (MethodInvokerRewriter.DontRewriteException drex) {
                return bytes;
            }
        }

        static class ChainedAdapters
        extends ClassVisitor
        implements Constants {
            public ChainedAdapters(ReloadableType rtype) {
                super(327680, new MethodInvokerRewriter.RewriteClassAdaptor(rtype.typeRegistry, (ClassVisitor)new TypeRewriter.RewriteClassAdaptor(rtype, new ClassWriter(1))));
            }

            public byte[] getBytes() {
                MethodInvokerRewriter.RewriteClassAdaptor rca = (MethodInvokerRewriter.RewriteClassAdaptor)this.cv;
                if (!rca.isEnum || rca.fieldcount > GlobalConfiguration.enumLimit) {
                    // empty if block
                }
                TypeRewriter.RewriteClassAdaptor a = (TypeRewriter.RewriteClassAdaptor)rca.getClassVisitor();
                return ((ClassWriter)a.getClassVisitor()).toByteArray();
            }
        }
    }
}

