/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.springframework.sync.PatchException;
import org.springframework.sync.PatchOperation;
import org.springframework.util.ObjectUtils;

public class TestOperation
extends PatchOperation {
    public TestOperation(String path, Object value) {
        super("test", path, value);
    }

    @Override
    <T> void perform(Object target, Class<T> type) {
        Object actual;
        Object expected = this.normalizeIfNumber(this.evaluateValueFromTarget(target, type));
        if (!ObjectUtils.nullSafeEquals((Object)expected, (Object)(actual = this.normalizeIfNumber(this.getValueFromTarget(target))))) {
            throw new PatchException("Test against path '" + this.path + "' failed.");
        }
    }

    private Object normalizeIfNumber(Object expected) {
        if (expected instanceof Double || expected instanceof Float) {
            expected = BigDecimal.valueOf(((Number)expected).doubleValue());
        } else if (expected instanceof Number) {
            expected = BigInteger.valueOf(((Number)expected).longValue());
        }
        return expected;
    }
}

