/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync.diffsync;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.sync.diffsync.AbstractShadowStore;

public class RedisShadowStore
extends AbstractShadowStore
implements DisposableBean {
    private RedisOperations<String, Object> redisTemplate;
    private List<String> keys = new ArrayList<String>();

    public RedisShadowStore(String remoteNodeId, RedisOperations<String, Object> redisTemplate) {
        super(remoteNodeId);
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void putShadow(String key, Object shadow) {
        String nodeKey = this.getNodeSpecificKey(key);
        this.redisTemplate.opsForValue().set((Object)nodeKey, shadow);
        this.keys.add(nodeKey);
    }

    @Override
    public Object getShadow(String key) {
        return this.redisTemplate.opsForValue().get((Object)this.getNodeSpecificKey(key));
    }

    public void destroy() throws Exception {
        this.redisTemplate.delete(this.keys);
    }
}

