/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import org.springframework.binding.collection.MapAdaptable;

public class MapAdaptableELResolver
extends ELResolver {
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof MapAdaptable) {
            return Object.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, ELException {
        if (context == null) {
            throw new NullPointerException("The ELContext is null.");
        }
        if (base instanceof MapAdaptable) {
            context.setPropertyResolved(true);
            Object obj = this.adapt(base).get(property);
            return obj != null ? obj.getClass() : null;
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, ELException {
        if (context == null) {
            throw new NullPointerException("The ELContext is null.");
        }
        if (base instanceof MapAdaptable) {
            context.setPropertyResolved(true);
            return this.adapt(base).get(property);
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, ELException {
        if (context == null) {
            throw new NullPointerException("The ELContext is null.");
        }
        if (base instanceof MapAdaptable) {
            context.setPropertyResolved(true);
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, ELException {
        if (context == null) {
            throw new NullPointerException("The ELContext is null.");
        }
        if (base instanceof MapAdaptable) {
            context.setPropertyResolved(true);
            try {
                this.adapt(base).put(property, value);
            }
            catch (UnsupportedOperationException e) {
                throw new PropertyNotWritableException((Throwable)e);
            }
        }
    }

    private Map<Object, Object> adapt(Object base) {
        MapAdaptable adaptable = (MapAdaptable)base;
        return adaptable.asMap();
    }
}

