/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.faces.model.SelectionAware;
import org.springframework.faces.model.SerializableListDataModel;
import org.springframework.util.Assert;

public class ManySelectionTrackingListDataModel<T>
extends SerializableListDataModel<T>
implements SelectionAware<T> {
    private List<T> selections = new ArrayList<T>();

    public ManySelectionTrackingListDataModel() {
    }

    public ManySelectionTrackingListDataModel(List<T> list) {
        super(list);
    }

    @Override
    public List<T> getSelections() {
        return this.selections;
    }

    @Override
    public boolean isCurrentRowSelected() {
        return this.selections.contains(this.getRowData());
    }

    @Override
    public void selectAll() {
        this.selections.clear();
        this.selections.addAll((Collection<T>)this.getWrappedData());
    }

    @Override
    public void setCurrentRowSelected(boolean rowSelected) {
        if (!this.isRowAvailable()) {
            return;
        }
        if (rowSelected && !this.selections.contains(this.getRowData())) {
            this.selections.add(this.getRowData());
        } else if (!rowSelected) {
            this.selections.remove(this.getRowData());
        }
    }

    @Override
    public void setSelections(List<T> selections) {
        this.selections = selections;
    }

    @Override
    public void select(T rowData) {
        Assert.isTrue((boolean)this.getWrappedData().contains(rowData), (String)"The object to select is not contained in this DataModel.");
        if (!this.selections.contains(rowData)) {
            this.selections.add(rowData);
        }
    }
}

