/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow.context.portlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.springframework.core.Ordered;
import org.springframework.faces.webflow.FacesContextHelper;
import org.springframework.faces.webflow.context.portlet.PortletResponseUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.portlet.HandlerAdapter;
import org.springframework.web.portlet.HandlerExecutionChain;
import org.springframework.web.portlet.HandlerMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.handler.PortletContentGenerator;

public class JsfResourceRequestHandler
extends PortletContentGenerator
implements HandlerAdapter,
HandlerMapping,
Ordered {
    private static final String FACES_RESOURCE = "javax.faces.resource";
    private static final String RESOURCE_EXCLUDES_DEFAULT = ".class .jsp .jspx .properties .xhtml .groovy";
    private static final String RESOURCE_EXCLUDES_PARAM_NAME = "javax.faces.RESOURCE_EXCLUDES";
    private int order = Integer.MIN_VALUE;

    public HandlerExecutionChain getHandler(PortletRequest request) throws Exception {
        if (request instanceof ResourceRequest && request.getParameter(FACES_RESOURCE) != null) {
            return new HandlerExecutionChain((Object)new JsfResourceRequest());
        }
        return null;
    }

    public boolean supports(Object handler) {
        return handler instanceof JsfResourceRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleResource(ResourceRequest request, ResourceResponse response, Object handler) throws IOException {
        FacesContextHelper helper = new FacesContextHelper();
        try {
            FacesContext facesContext = helper.getFacesContext(this.getPortletContext(), request, response);
            this.handleResourceRequest(facesContext, request, response);
        }
        finally {
            helper.releaseIfNecessary();
        }
        return null;
    }

    private void handleResourceRequest(FacesContext facesContext, ResourceRequest request, ResourceResponse response) throws IOException {
        ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
        String resourceName = request.getParameter(FACES_RESOURCE);
        String libraryName = request.getParameter("ln");
        int statusCodeNotFound = HttpStatus.NOT_FOUND.value();
        if (this.isResourceExcluded(facesContext, resourceName)) {
            response.setProperty("portlet.http-status-code", String.valueOf(statusCodeNotFound));
            PortletResponseUtils.setStatusCodeForPluto((PortletResponse)response, statusCodeNotFound);
            return;
        }
        Resource resource = this.createResource(resourceHandler, resourceName, libraryName);
        if (resource == null) {
            response.setProperty("portlet.http-status-code", String.valueOf(statusCodeNotFound));
            PortletResponseUtils.setStatusCodeForPluto((PortletResponse)response, statusCodeNotFound);
            return;
        }
        for (Map.Entry entry : resource.getResponseHeaders().entrySet()) {
            response.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        response.setContentType(resource.getContentType());
        FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)response.getPortletOutputStream());
    }

    private boolean isResourceExcluded(FacesContext context, String resourceName) {
        for (String resourceExclude : this.getResourceExcludes(context)) {
            if (!StringUtils.endsWithIgnoreCase((String)resourceName, (String)resourceExclude)) continue;
            return true;
        }
        return false;
    }

    private String[] getResourceExcludes(FacesContext context) {
        String resourceExcludes = context.getExternalContext().getInitParameter(RESOURCE_EXCLUDES_PARAM_NAME);
        if (resourceExcludes == null) {
            resourceExcludes = RESOURCE_EXCLUDES_DEFAULT;
        }
        return StringUtils.tokenizeToStringArray((String)resourceExcludes, (String)" ");
    }

    private Resource createResource(ResourceHandler resourceHandler, String resourceName, String libraryName) {
        if (libraryName != null) {
            return resourceHandler.createResource(resourceName, libraryName);
        }
        return resourceHandler.createResource(resourceName);
    }

    public void handleAction(ActionRequest request, ActionResponse response, Object handler) throws Exception {
    }

    public ModelAndView handleRender(RenderRequest request, RenderResponse response, Object handler) throws Exception {
        return null;
    }

    public void handleEvent(EventRequest request, EventResponse response, Object handler) throws Exception {
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private static class JsfResourceRequest {
        private JsfResourceRequest() {
        }
    }
}

