/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.util.HashMap;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.facelets.FaceletCacheFactory;
import javax.faces.view.facelets.TagHandlerDelegateFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.RequestContextHolder;

public class JsfUtils {
    private static final Map<Class<?>, String> FACTORY_NAMES = new HashMap();

    public static void notifyAfterListeners(PhaseId phaseId, Lifecycle lifecycle, FacesContext context) {
        PhaseEvent afterPhaseEvent = new PhaseEvent(context, phaseId, lifecycle);
        for (int i = lifecycle.getPhaseListeners().length - 1; i >= 0; --i) {
            PhaseListener listener = lifecycle.getPhaseListeners()[i];
            if (listener.getPhaseId() != phaseId && listener.getPhaseId() != PhaseId.ANY_PHASE) continue;
            listener.afterPhase(afterPhaseEvent);
        }
    }

    public static void notifyBeforeListeners(PhaseId phaseId, Lifecycle lifecycle, FacesContext context) {
        PhaseEvent beforePhaseEvent = new PhaseEvent(context, phaseId, lifecycle);
        for (int i = 0; i < lifecycle.getPhaseListeners().length; ++i) {
            PhaseListener listener = lifecycle.getPhaseListeners()[i];
            if (listener.getPhaseId() != phaseId && listener.getPhaseId() != PhaseId.ANY_PHASE) continue;
            listener.beforePhase(beforePhaseEvent);
        }
    }

    public static boolean isFlowRequest() {
        return RequestContextHolder.getRequestContext() != null;
    }

    public static boolean isAsynchronousFlowRequest() {
        return JsfUtils.isFlowRequest() && RequestContextHolder.getRequestContext().getExternalContext().isAjaxRequest();
    }

    public static <T> T findFactory(Class<T> factoryClass) {
        Assert.notNull(factoryClass, (String)"FactoryClass must not be null");
        String name = FACTORY_NAMES.get(factoryClass);
        Assert.state((name != null ? 1 : 0) != 0, (String)("Unknown factory class " + factoryClass.getName()));
        return (T)FactoryFinder.getFactory((String)name);
    }

    static {
        FACTORY_NAMES.put(ApplicationFactory.class, "javax.faces.application.ApplicationFactory");
        FACTORY_NAMES.put(ExceptionHandlerFactory.class, "javax.faces.context.ExceptionHandlerFactory");
        FACTORY_NAMES.put(ExternalContextFactory.class, "javax.faces.context.ExternalContextFactory");
        FACTORY_NAMES.put(FaceletCacheFactory.class, "javax.faces.view.facelets.FaceletCacheFactory");
        FACTORY_NAMES.put(FacesContextFactory.class, "javax.faces.context.FacesContextFactory");
        FACTORY_NAMES.put(LifecycleFactory.class, "javax.faces.lifecycle.LifecycleFactory");
        FACTORY_NAMES.put(PartialViewContextFactory.class, "javax.faces.context.PartialViewContextFactory");
        FACTORY_NAMES.put(RenderKitFactory.class, "javax.faces.render.RenderKitFactory");
        FACTORY_NAMES.put(TagHandlerDelegateFactory.class, "javax.faces.view.facelets.TagHandlerDelegateFactory");
        FACTORY_NAMES.put(ViewDeclarationLanguageFactory.class, "javax.faces.view.ViewDeclarationLanguageFactory");
        FACTORY_NAMES.put(VisitContextFactory.class, "javax.faces.component.visit.VisitContextFactory");
    }
}

