/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class FormObjectAccessor {
    private static final String CURRENT_FORM_OBJECT_ATTRIBUTE = "currentFormObject";
    private static final String ERRORS_PREFIX = BindingResult.MODEL_KEY_PREFIX;
    private RequestContext context;
    static /* synthetic */ Class class$0;

    public FormObjectAccessor(RequestContext context) {
        this.context = context;
    }

    public static String getCurrentFormObjectName() {
        return CURRENT_FORM_OBJECT_ATTRIBUTE;
    }

    public static String getCurrentFormErrorsName() {
        return String.valueOf(ERRORS_PREFIX) + FormObjectAccessor.getCurrentFormObjectName();
    }

    public Object getCurrentFormObject() {
        Object formObject = this.getCurrentFormObject(ScopeType.REQUEST);
        if (formObject != null) {
            return formObject;
        }
        formObject = this.getCurrentFormObject(ScopeType.FLASH);
        if (formObject != null) {
            return formObject;
        }
        formObject = this.getCurrentFormObject(ScopeType.FLOW);
        if (formObject != null) {
            return formObject;
        }
        return this.getCurrentFormObject(ScopeType.CONVERSATION);
    }

    public Object getCurrentFormObject(ScopeType scopeType) {
        return this.getFormObject(FormObjectAccessor.getCurrentFormObjectName(), scopeType);
    }

    public void setCurrentFormObject(Object formObject, ScopeType scopeType) {
        scopeType.getScope(this.context).put(FormObjectAccessor.getCurrentFormObjectName(), formObject);
    }

    public Object getFormObject(String formObjectName, ScopeType scopeType) {
        return scopeType.getScope(this.context).get(formObjectName);
    }

    public Object getFormObject(String formObjectName, Class formObjectClass, ScopeType scopeType) {
        return scopeType.getScope(this.context).get(formObjectName, formObjectClass);
    }

    public void putFormObject(Object formObject, String formObjectName, ScopeType scopeType) {
        scopeType.getScope(this.context).put(formObjectName, formObject);
        this.setCurrentFormObject(formObject, scopeType);
    }

    public Errors getCurrentFormErrors() {
        Errors errors = this.getCurrentFormErrors(ScopeType.REQUEST);
        if (errors != null) {
            return errors;
        }
        errors = this.getCurrentFormErrors(ScopeType.FLASH);
        if (errors != null) {
            return errors;
        }
        errors = this.getCurrentFormErrors(ScopeType.FLOW);
        if (errors != null) {
            return errors;
        }
        return this.getCurrentFormErrors(ScopeType.CONVERSATION);
    }

    public Errors getCurrentFormErrors(ScopeType scopeType) {
        return this.getFormErrors(FormObjectAccessor.getCurrentFormObjectName(), scopeType);
    }

    public void setCurrentFormErrors(Errors errors, ScopeType scopeType) {
        scopeType.getScope(this.context).put(FormObjectAccessor.getCurrentFormErrorsName(), errors);
    }

    public Errors getFormErrors(String formObjectName, ScopeType scopeType) {
        MutableAttributeMap mutableAttributeMap = scopeType.getScope(this.context);
        String string = String.valueOf(ERRORS_PREFIX) + formObjectName;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.validation.Errors");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Errors)mutableAttributeMap.get(string, clazz);
    }

    public void putFormErrors(Errors errors, ScopeType scopeType) {
        scopeType.getScope(this.context).put(String.valueOf(ERRORS_PREFIX) + errors.getObjectName(), errors);
        this.setCurrentFormErrors(errors, scopeType);
    }
}

