/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.view;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.support.FluentParserContext;
import org.springframework.binding.expression.support.StaticExpression;
import org.springframework.binding.mapping.MappingResult;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.MappingResultsCriteria;
import org.springframework.binding.mapping.impl.DefaultMapper;
import org.springframework.binding.mapping.impl.DefaultMapping;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageResolver;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.mvc.view.BindingModel;
import org.springframework.webflow.mvc.view.ViewActionStateHolder;
import org.springframework.webflow.validation.ValidationHelper;

public abstract class AbstractMvcView
implements View {
    private static final Log logger;
    private static final MappingResultsCriteria PROPERTY_NOT_FOUND_ERROR;
    private static final MappingResultsCriteria MAPPING_ERROR;
    private org.springframework.web.servlet.View view;
    private RequestContext requestContext;
    private ExpressionParser expressionParser;
    private ConversionService conversionService;
    private String fieldMarkerPrefix = "_";
    private String eventIdParameterName = "_eventId";
    private String eventId;
    private MappingResults mappingResults;
    private BinderConfiguration binderConfiguration;
    private MessageCodesResolver messageCodesResolver;
    private boolean userEventProcessed;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.mvc.view.AbstractMvcView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
        PROPERTY_NOT_FOUND_ERROR = new PropertyNotFoundError();
        MAPPING_ERROR = new MappingError();
    }

    public AbstractMvcView(org.springframework.web.servlet.View view, RequestContext requestContext) {
        this.view = view;
        this.requestContext = requestContext;
    }

    public void setExpressionParser(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setBinderConfiguration(BinderConfiguration binderConfiguration) {
        this.binderConfiguration = binderConfiguration;
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    public void setFieldMarkerPrefix(String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    public void setEventIdParameterName(String eventIdParameterName) {
        this.eventIdParameterName = eventIdParameterName;
    }

    public void render() throws IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(this.flowScopes());
        this.exposeBindingModel(model);
        model.put("flowRequestContext", this.requestContext);
        FlowExecutionKey key = this.requestContext.getFlowExecutionContext().getKey();
        if (key != null) {
            model.put("flowExecutionKey", this.requestContext.getFlowExecutionContext().getKey().toString());
            model.put("flowExecutionUrl", this.requestContext.getFlowExecutionUrl());
        }
        model.put("currentUser", this.requestContext.getExternalContext().getCurrentUser());
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Rendering MVC [" + this.view + "] with model map [" + model + "]"));
            }
            this.doRender(model);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Exception occurred rendering view " + this.view);
            ise.initCause(e);
            throw ise;
        }
    }

    public boolean userEventQueued() {
        return !this.userEventProcessed && this.getEventId() != null;
    }

    public void processUserEvent() {
        Object model;
        String eventId = this.getEventId();
        if (eventId == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processing user event '" + eventId + "'"));
        }
        if ((model = this.getModelObject()) != null) {
            TransitionDefinition transition;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resolved model " + model));
            }
            if (this.shouldBind(model, transition = this.requestContext.getMatchingTransition(eventId))) {
                this.mappingResults = this.bind(model);
                if (this.hasErrors(this.mappingResults)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Model binding resulted in errors; adding error messages to context");
                    }
                    this.addErrorMessages(this.mappingResults);
                }
                if (this.shouldValidate(model, transition)) {
                    this.validate(model);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"No model to bind to; done processing user event");
        }
        this.userEventProcessed = true;
    }

    public Serializable getUserEventState() {
        return new ViewActionStateHolder(this.eventId, this.userEventProcessed, this.mappingResults);
    }

    public boolean hasFlowEvent() {
        return this.userEventProcessed && !this.requestContext.getMessageContext().hasErrorMessages();
    }

    public Event getFlowEvent() {
        if (!this.hasFlowEvent()) {
            return null;
        }
        return new Event(this, this.getEventId(), this.requestContext.getRequestParameters().asAttributeMap());
    }

    public void saveState() {
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("view", (Object)this.view).toString();
    }

    protected RequestContext getRequestContext() {
        return this.requestContext;
    }

    protected org.springframework.web.servlet.View getView() {
        return this.view;
    }

    protected abstract void doRender(Map var1) throws Exception;

    protected String getEventId() {
        if (this.eventId == null) {
            this.eventId = this.determineEventId(this.requestContext);
        }
        return this.eventId;
    }

    protected boolean shouldBind(Object model, TransitionDefinition transition) {
        if (transition == null) {
            return true;
        }
        return transition.getAttributes().getBoolean("bind", Boolean.TRUE);
    }

    protected MappingResults getMappingResults() {
        return this.mappingResults;
    }

    protected String determineEventId(RequestContext context) {
        return WebUtils.findParameterValue((Map)context.getRequestParameters().asMap(), (String)this.eventIdParameterName);
    }

    void restoreState(ViewActionStateHolder stateHolder) {
        this.eventId = stateHolder.getEventId();
        this.userEventProcessed = stateHolder.getUserEventProcessed();
        this.mappingResults = stateHolder.getMappingResults();
    }

    private boolean shouldValidate(Object model, TransitionDefinition transition) {
        Boolean validateAttribute = this.getValidateAttribute(transition);
        if (validateAttribute != null) {
            return validateAttribute;
        }
        AttributeMap flowExecutionAttributes = this.requestContext.getFlowExecutionContext().getAttributes();
        Boolean validateOnBindingErrors = flowExecutionAttributes.getBoolean("validateOnBindingErrors");
        return validateOnBindingErrors == null || validateOnBindingErrors != false || !this.mappingResults.hasErrorResults();
    }

    private Map flowScopes() {
        if (this.requestContext.getCurrentState().isViewState()) {
            return this.requestContext.getConversationScope().union(this.requestContext.getFlowScope()).union(this.requestContext.getViewScope()).union(this.requestContext.getFlashScope()).union(this.requestContext.getRequestScope()).asMap();
        }
        return this.requestContext.getConversationScope().union(this.requestContext.getFlowScope()).union(this.requestContext.getFlashScope()).union(this.requestContext.getRequestScope()).asMap();
    }

    private void exposeBindingModel(Map model) {
        Object modelObject = this.getModelObject();
        if (modelObject != null) {
            BindingModel bindingModel = new BindingModel(this.getModelExpression().getExpressionString(), modelObject, this.expressionParser, this.conversionService, this.requestContext.getMessageContext());
            bindingModel.setBinderConfiguration(this.binderConfiguration);
            bindingModel.setMappingResults(this.mappingResults);
            model.put(String.valueOf(BindingResult.MODEL_KEY_PREFIX) + this.getModelExpression().getExpressionString(), bindingModel);
        }
    }

    private Object getModelObject() {
        Expression model = this.getModelExpression();
        if (model != null) {
            return model.getValue((Object)this.requestContext);
        }
        return null;
    }

    private Expression getModelExpression() {
        return (Expression)this.requestContext.getCurrentState().getAttributes().get("model");
    }

    private MappingResults bind(Object model) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Binding to model");
        }
        DefaultMapper mapper = new DefaultMapper();
        ParameterMap requestParameters = this.requestContext.getRequestParameters();
        if (this.binderConfiguration != null) {
            this.addModelBindings(mapper, requestParameters.asMap().keySet(), model);
        } else {
            this.addDefaultMappings(mapper, requestParameters.asMap().keySet(), model);
        }
        return mapper.map((Object)requestParameters, model);
    }

    private void addModelBindings(DefaultMapper mapper, Set parameterNames, Object model) {
        Iterator it = this.binderConfiguration.getBindings().iterator();
        while (it.hasNext()) {
            BinderConfiguration.Binding binding = (BinderConfiguration.Binding)it.next();
            String parameterName = binding.getProperty();
            if (parameterNames.contains(parameterName)) {
                this.addMapping(mapper, binding, model);
                continue;
            }
            if (this.fieldMarkerPrefix == null || !parameterNames.contains(String.valueOf(this.fieldMarkerPrefix) + parameterName)) continue;
            this.addEmptyValueMapping(mapper, parameterName, model);
        }
    }

    private void addMapping(DefaultMapper mapper, BinderConfiguration.Binding binding, Object model) {
        RequestParameterExpression source = new RequestParameterExpression(binding.getProperty());
        FluentParserContext parserContext = new FluentParserContext().evaluate(model.getClass());
        Expression target = this.expressionParser.parseExpression(binding.getProperty(), (ParserContext)parserContext);
        DefaultMapping mapping = new DefaultMapping((Expression)source, target);
        mapping.setRequired(binding.getRequired());
        if (binding.getConverter() != null) {
            Assert.notNull((Object)this.conversionService, (String)"A ConversionService must be configured to use resolve custom converters to use during binding");
            String string = binding.getConverter();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ConversionExecutor conversionExecutor = this.conversionService.getConversionExecutor(string, (Class)clazz, target.getValueType(model));
            mapping.setTypeConverter(conversionExecutor);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding mapping for parameter '" + binding.getProperty() + "'"));
        }
        mapper.addMapping(mapping);
    }

    private void addDefaultMappings(DefaultMapper mapper, Set parameterNames, Object model) {
        Iterator it = parameterNames.iterator();
        while (it.hasNext()) {
            String parameterName = (String)it.next();
            if (this.fieldMarkerPrefix != null && parameterName.startsWith(this.fieldMarkerPrefix)) {
                String field = parameterName.substring(this.fieldMarkerPrefix.length());
                if (parameterNames.contains(field)) continue;
                this.addEmptyValueMapping(mapper, field, model);
                continue;
            }
            this.addDefaultMapping(mapper, parameterName, model);
        }
    }

    private void addEmptyValueMapping(DefaultMapper mapper, String field, Object model) {
        FluentParserContext parserContext = new FluentParserContext().evaluate(model.getClass());
        Expression target = this.expressionParser.parseExpression(field, (ParserContext)parserContext);
        try {
            Class propertyType = target.getValueType(model);
            StaticExpression source = new StaticExpression(this.getEmptyValue(propertyType));
            DefaultMapping mapping = new DefaultMapping((Expression)source, target);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding empty value mapping for parameter '" + field + "'"));
            }
            mapper.addMapping(mapping);
        }
        catch (EvaluationException evaluationException) {}
    }

    private Object getEmptyValue(Class fieldType) {
        block9: {
            block8: {
                if (fieldType != null && Boolean.TYPE.equals(fieldType)) break block8;
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.equals(fieldType)) break block9;
            }
            return Boolean.FALSE;
        }
        if (fieldType != null && fieldType.isArray()) {
            return Array.newInstance(fieldType.getComponentType(), 0);
        }
        return null;
    }

    private void addDefaultMapping(DefaultMapper mapper, String parameter, Object model) {
        RequestParameterExpression source = new RequestParameterExpression(parameter);
        FluentParserContext parserContext = new FluentParserContext().evaluate(model.getClass());
        Expression target = this.expressionParser.parseExpression(parameter, (ParserContext)parserContext);
        DefaultMapping mapping = new DefaultMapping((Expression)source, target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding default mapping for parameter '" + parameter + "'"));
        }
        mapper.addMapping(mapping);
    }

    private boolean hasErrors(MappingResults results) {
        return results.hasErrorResults() && !this.onlyPropertyNotFoundErrorsPresent(results);
    }

    private boolean onlyPropertyNotFoundErrorsPresent(MappingResults results) {
        return results.getResults(PROPERTY_NOT_FOUND_ERROR).size() == this.mappingResults.getErrorResults().size();
    }

    private void addErrorMessages(MappingResults results) {
        List errors = results.getResults(MAPPING_ERROR);
        Iterator it = errors.iterator();
        while (it.hasNext()) {
            MappingResult error = (MappingResult)it.next();
            this.requestContext.getMessageContext().addMessage(this.createMessageResolver(error));
        }
    }

    private MessageResolver createMessageResolver(MappingResult error) {
        String model = this.getModelExpression().getExpressionString();
        String field = error.getMapping().getTargetExpression().getExpressionString();
        Class fieldType = error.getMapping().getTargetExpression().getValueType(this.getModelObject());
        String[] messageCodes = this.messageCodesResolver.resolveMessageCodes(error.getCode(), model, field, fieldType);
        return new MessageBuilder().error().source((Object)field).codes(messageCodes).resolvableArg((Object)field).defaultText(String.valueOf(error.getCode()) + " on " + field).build();
    }

    private Boolean getValidateAttribute(TransitionDefinition transition) {
        if (transition != null) {
            return transition.getAttributes().getBoolean("validate");
        }
        return null;
    }

    private void validate(Object model) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Validating model");
        }
        new ValidationHelper(model, this.requestContext, this.eventId, this.getModelExpression().getExpressionString(), this.expressionParser, this.messageCodesResolver, this.mappingResults).validate();
    }

    private static class MappingError
    implements MappingResultsCriteria {
        private MappingError() {
        }

        public boolean test(MappingResult result) {
            return result.isError() && !PROPERTY_NOT_FOUND_ERROR.test(result);
        }
    }

    private static class PropertyNotFoundError
    implements MappingResultsCriteria {
        private PropertyNotFoundError() {
        }

        public boolean test(MappingResult result) {
            return result.isError() && "propertyNotFound".equals(result.getCode());
        }
    }

    private static class RequestParameterExpression
    implements Expression {
        private String parameterName;

        public RequestParameterExpression(String parameterName) {
            this.parameterName = parameterName;
        }

        public String getExpressionString() {
            return this.parameterName;
        }

        public Object getValue(Object context) throws EvaluationException {
            ParameterMap parameters = (ParameterMap)context;
            return parameters.asMap().get(this.parameterName);
        }

        public Class getValueType(Object context) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public void setValue(Object context, Object value) throws EvaluationException {
            throw new UnsupportedOperationException("Setting request parameters is not allowed");
        }

        public String toString() {
            return "parameter:'" + this.parameterName + "'";
        }
    }
}

