/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.snapshot;

import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.repository.FlowExecutionRestorationFailureException;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshot;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.snapshot.SnapshotCreationException;

public class SimpleFlowExecutionSnapshotFactory
implements FlowExecutionSnapshotFactory {
    private FlowExecutionFactory flowExecutionFactory;
    private FlowDefinitionLocator flowDefinitionLocator;

    public SimpleFlowExecutionSnapshotFactory(FlowExecutionFactory flowExecutionFactory, FlowDefinitionLocator flowDefinitionLocator) {
        Assert.notNull((Object)flowExecutionFactory, (String)"The FlowExecutionFactory to restore transient flow state is required");
        Assert.notNull((Object)flowDefinitionLocator, (String)"The FlowDefinitionLocator to restore FlowDefinitions is required");
        this.flowExecutionFactory = flowExecutionFactory;
        this.flowDefinitionLocator = flowDefinitionLocator;
    }

    @Override
    public FlowExecutionSnapshot createSnapshot(FlowExecution flowExecution) throws SnapshotCreationException {
        return new SimpleFlowExecutionSnapshot(flowExecution);
    }

    @Override
    public FlowExecution restoreExecution(FlowExecutionSnapshot snapshot, String flowId, FlowExecutionKey key, MutableAttributeMap<Object> conversationScope, FlowExecutionKeyFactory keyFactory) throws FlowExecutionRestorationFailureException {
        SimpleFlowExecutionSnapshot snapshotImpl = (SimpleFlowExecutionSnapshot)snapshot;
        FlowDefinition def = this.flowDefinitionLocator.getFlowDefinition(flowId);
        FlowExecution execution = snapshotImpl.getFlowExecution();
        this.flowExecutionFactory.restoreFlowExecution(execution, def, key, conversationScope, this.flowDefinitionLocator);
        return execution;
    }

    private static class SimpleFlowExecutionSnapshot
    extends FlowExecutionSnapshot {
        private FlowExecution flowExecution;

        public SimpleFlowExecutionSnapshot(FlowExecution flowExecution) {
            this.flowExecution = flowExecution;
        }

        public FlowExecution getFlowExecution() {
            return this.flowExecution;
        }
    }
}

