/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model.registry;

import java.util.Map;
import java.util.TreeMap;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.model.FlowModel;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;
import org.springframework.webflow.engine.model.registry.FlowModelRegistry;
import org.springframework.webflow.engine.model.registry.NoSuchFlowModelException;

public class FlowModelRegistryImpl
implements FlowModelRegistry {
    private Map<String, FlowModelHolder> flowModels = new TreeMap<String, FlowModelHolder>();
    private FlowModelRegistry parent;

    @Override
    public FlowModel getFlowModel(String id) throws NoSuchFlowModelException {
        try {
            return this.getFlowModelHolder(id).getFlowModel();
        }
        catch (NoSuchFlowModelException e) {
            if (this.parent != null) {
                return this.parent.getFlowModel(id);
            }
            throw e;
        }
    }

    @Override
    public void setParent(FlowModelRegistry parent) {
        this.parent = parent;
    }

    @Override
    public void registerFlowModel(String id, FlowModelHolder modelHolder) {
        Assert.notNull((Object)modelHolder, (String)"The holder of the flow model to register is required");
        this.flowModels.put(id, modelHolder);
    }

    private FlowModelHolder getFlowModelHolder(String id) throws NoSuchFlowModelException {
        FlowModelHolder holder = this.flowModels.get(id);
        if (holder == null) {
            throw new NoSuchFlowModelException(id);
        }
        return holder;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowModels", this.flowModels).append("parent", (Object)this.parent).toString();
    }
}

