/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import java.io.IOException;
import java.io.Serializable;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.core.style.ToStringCreator;
import org.springframework.validation.Validator;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.execution.ViewFactory;
import org.springframework.webflow.validation.ValidationHintResolver;

class MockViewFactoryCreator
implements ViewFactoryCreator {
    MockViewFactoryCreator() {
    }

    @Override
    public ViewFactory createViewFactory(Expression viewId, ExpressionParser expressionParser, ConversionService conversionService, BinderConfiguration binderConfiguration, Validator validator, ValidationHintResolver resolver) {
        return new MockViewFactory(viewId);
    }

    @Override
    public String getViewIdByConvention(String viewStateId) {
        return viewStateId;
    }

    static class MockView
    implements View {
        private String viewId;
        private RequestContext context;

        public MockView(String viewId, RequestContext context) {
            this.viewId = viewId;
            this.context = context;
        }

        public String getViewId() {
            return this.viewId;
        }

        @Override
        public void render() throws IOException {
            this.context.getExternalContext().getResponseWriter().write(this.viewId);
        }

        @Override
        public boolean userEventQueued() {
            return this.hasFlowEvent();
        }

        @Override
        public void processUserEvent() {
        }

        @Override
        public Serializable getUserEventState() {
            return null;
        }

        @Override
        public boolean hasFlowEvent() {
            return this.context.getRequestParameters().contains("_eventId");
        }

        @Override
        public Event getFlowEvent() {
            return new Event(this, this.context.getRequestParameters().get("_eventId"));
        }

        @Override
        public void saveState() {
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("viewId", (Object)this.viewId).toString();
        }
    }

    static class MockViewFactory
    implements ViewFactory {
        private Expression viewId;

        public MockViewFactory(Expression viewId) {
            this.viewId = viewId;
        }

        @Override
        public View getView(RequestContext context) {
            String viewId = (String)this.viewId.getValue((Object)context);
            return new MockView(viewId, context);
        }
    }
}

