/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security;

import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.security.WsSecuritySecurementException;
import org.springframework.ws.soap.security.WsSecurityValidationException;
import org.springframework.ws.soap.server.SoapEndpointInterceptor;

public abstract class AbstractWsSecurityInterceptor
implements SoapEndpointInterceptor {
    private static final QName WS_SECURITY_NAME = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean secureResponse = true;
    private boolean validateRequest = true;

    public void setSecureResponse(boolean secureResponse) {
        this.secureResponse = secureResponse;
    }

    public void setValidateRequest(boolean validateRequest) {
        this.validateRequest = validateRequest;
    }

    public final boolean handleRequest(MessageContext messageContext, Object endpoint) throws Exception {
        if (this.validateRequest) {
            Assert.isTrue((boolean)(messageContext.getRequest() instanceof SoapMessage), (String)"WsSecurityInterceptor requires a SoapMessage request");
            try {
                this.validateMessage((SoapMessage)messageContext.getRequest());
                return true;
            }
            catch (WsSecurityValidationException ex) {
                return this.handleValidationException(ex, messageContext);
            }
        }
        return true;
    }

    public final boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        if (this.secureResponse) {
            Assert.isTrue((boolean)(messageContext.getResponse() instanceof SoapMessage), (String)"WsSecurityInterceptor requires a SoapMessage response");
            try {
                this.secureMessage((SoapMessage)messageContext.getResponse());
                return true;
            }
            catch (WsSecuritySecurementException ex) {
                return this.handleSecurementException(ex, messageContext);
            }
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        return true;
    }

    public boolean understands(SoapHeaderElement headerElement) {
        return WS_SECURITY_NAME.equals(headerElement.getName());
    }

    protected boolean handleSecurementException(WsSecuritySecurementException ex, MessageContext messageContext) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)("Could not secure response: " + ex.getMessage()), (Throwable)((Object)ex));
        }
        return false;
    }

    protected boolean handleValidationException(WsSecurityValidationException ex, MessageContext messageContext) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Could not validate request: " + ex.getMessage()));
        }
        SoapBody response = ((SoapMessage)messageContext.getResponse()).getSoapBody();
        response.addClientOrSenderFault(ex.getMessage(), Locale.ENGLISH);
        return false;
    }

    protected abstract void validateMessage(SoapMessage var1) throws WsSecurityValidationException;

    protected abstract void secureMessage(SoapMessage var1) throws WsSecuritySecurementException;
}

