/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.ws.wsdl.WsdlDefinition;
import org.springframework.xml.transform.TransformerObjectSupport;

public class WsdlDefinitionHttpHandler
extends TransformerObjectSupport
implements HttpHandler,
InitializingBean {
    private static final String CONTENT_TYPE = "text/xml";
    private WsdlDefinition definition;

    public WsdlDefinitionHttpHandler() {
    }

    public WsdlDefinitionHttpHandler(WsdlDefinition definition) {
        this.definition = definition;
    }

    public void setDefinition(WsdlDefinition definition) {
        this.definition = definition;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.definition, (String)"'definition' is required");
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try (HttpExchange httpExchange2 = httpExchange;){
            if ("GET".equals(httpExchange.getRequestMethod())) {
                Headers headers = httpExchange.getResponseHeaders();
                headers.set("Content-Type", CONTENT_TYPE);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.transform(this.definition.getSource(), new StreamResult(os));
                byte[] buf = os.toByteArray();
                httpExchange.sendResponseHeaders(200, buf.length);
                FileCopyUtils.copy((byte[])buf, (OutputStream)httpExchange.getResponseBody());
            } else {
                httpExchange.sendResponseHeaders(405, -1L);
            }
        }
        catch (TransformerException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
    }
}

