/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.server;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.test.server.ResponseMatcher;
import org.springframework.ws.test.support.AssertionErrors;

abstract class SoapFaultResponseMatcher
implements ResponseMatcher {
    private final String expectedFaultStringOrReason;

    SoapFaultResponseMatcher(String expectedFaultStringOrReason) {
        this.expectedFaultStringOrReason = expectedFaultStringOrReason;
    }

    public void match(WebServiceMessage request, WebServiceMessage response) throws IOException, AssertionError {
        AssertionErrors.assertTrue("Response is not a SOAP message", response instanceof SoapMessage);
        SoapMessage soapResponse = (SoapMessage)response;
        SoapBody responseBody = soapResponse.getSoapBody();
        AssertionErrors.assertTrue("Response has no SOAP Body", responseBody != null);
        AssertionErrors.assertTrue("Response has no SOAP Fault", responseBody.hasFault());
        SoapFault soapFault = responseBody.getFault();
        QName expectedFaultCode = this.getExpectedFaultCode(soapResponse.getVersion());
        AssertionErrors.assertEquals("Invalid SOAP Fault code", expectedFaultCode, soapFault.getFaultCode());
        if (this.expectedFaultStringOrReason != null) {
            AssertionErrors.assertEquals("Invalid SOAP Fault string/reason", this.expectedFaultStringOrReason, soapFault.getFaultStringOrReason());
        }
    }

    protected abstract QName getExpectedFaultCode(SoapVersion var1);
}

