/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.client;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.ws.test.client.MockSenderConnection;
import org.springframework.ws.transport.WebServiceMessageSender;

public class MockWebServiceMessageSender
implements WebServiceMessageSender {
    private final List<MockSenderConnection> expectedConnections = new LinkedList<MockSenderConnection>();
    private Iterator<MockSenderConnection> connectionIterator;

    public MockSenderConnection createConnection(URI uri) throws IOException {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        if (this.connectionIterator == null) {
            this.connectionIterator = this.expectedConnections.iterator();
        }
        if (!this.connectionIterator.hasNext()) {
            throw new AssertionError((Object)"No further connections expected");
        }
        MockSenderConnection currentConnection = this.connectionIterator.next();
        currentConnection.setUri(uri);
        return currentConnection;
    }

    public boolean supports(URI uri) {
        return true;
    }

    MockSenderConnection expectNewConnection() {
        Assert.state((this.connectionIterator == null ? 1 : 0) != 0, (String)"Can not expect another connection, the test is already underway");
        MockSenderConnection connection = new MockSenderConnection();
        this.expectedConnections.add(connection);
        return connection;
    }

    void verifyConnections() {
        if (this.expectedConnections.isEmpty()) {
            return;
        }
        if (this.connectionIterator == null || this.connectionIterator.hasNext()) {
            throw new AssertionError((Object)"Further connection(s) expected");
        }
    }

    void reset() {
        this.expectedConnections.clear();
        this.connectionIterator = null;
    }
}

