/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.support;

import javax.xml.transform.Source;
import org.springframework.ws.test.support.SourceAssertionError;

public abstract class AssertionErrors {
    private AssertionErrors() {
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static void fail(String message, String sourceLabel, Source source) {
        if (source != null) {
            throw new SourceAssertionError(message, sourceLabel, source);
        }
        AssertionErrors.fail(message);
    }

    public static void assertTrue(String message, boolean condition) {
        AssertionErrors.assertTrue(message, condition, null, null);
    }

    public static void assertTrue(String message, boolean condition, String sourceLabel, Source source) {
        if (!condition) {
            AssertionErrors.fail(message, sourceLabel, source);
        }
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        AssertionErrors.assertEquals(message, expected, actual, null, null);
    }

    public static void assertEquals(String message, Object expected, Object actual, String sourceLabel, Source source) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        AssertionErrors.fail(message + " expected:<" + String.valueOf(expected) + "> but was:<" + String.valueOf(actual) + ">", sourceLabel, source);
    }
}

