/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.lang.annotation.Annotation;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.mapping.AbstractMethodEndpointMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationMethodEndpointMapping
extends AbstractMethodEndpointMapping {
    private boolean detectEndpointsInAncestorContexts = false;

    public void setDetectEndpointsInAncestorContexts(boolean detectEndpointsInAncestorContexts) {
        this.detectEndpointsInAncestorContexts = detectEndpointsInAncestorContexts;
    }

    protected Class<? extends Annotation> getEndpointAnnotationType() {
        return Endpoint.class;
    }

    protected final void initApplicationContext() throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for endpoints in application context: " + this.getApplicationContext()));
        }
        String[] beanNames = this.detectEndpointsInAncestorContexts ? BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), Object.class) : this.getApplicationContext().getBeanNamesForType(Object.class);
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            Class endpointClass = this.getApplicationContext().getType(beanName);
            if (endpointClass == null || AnnotationUtils.findAnnotation((Class)endpointClass, this.getEndpointAnnotationType()) == null) continue;
            this.registerMethods(beanName);
        }
    }
}

