/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.core;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.springframework.ws.soap.addressing.core.EndpointReference;

public final class MessageAddressingProperties
implements Serializable {
    private static final long serialVersionUID = -6980663311446506672L;
    private final URI to;
    private final EndpointReference from;
    private final EndpointReference replyTo;
    private final EndpointReference faultTo;
    private final URI action;
    private final URI messageId;
    private final URI relatesTo;
    private final List referenceProperties;
    private final List referenceParameters;

    public MessageAddressingProperties(URI to, EndpointReference from, EndpointReference replyTo, EndpointReference faultTo, URI action, URI messageId) {
        this.to = to;
        this.from = from;
        this.replyTo = replyTo;
        this.faultTo = faultTo;
        this.action = action;
        this.messageId = messageId;
        this.relatesTo = null;
        this.referenceProperties = Collections.EMPTY_LIST;
        this.referenceParameters = Collections.EMPTY_LIST;
    }

    private MessageAddressingProperties(EndpointReference epr, URI action, URI messageId, URI relatesTo) {
        this.to = epr.getAddress();
        this.action = action;
        this.messageId = messageId;
        this.relatesTo = relatesTo;
        this.referenceParameters = epr.getReferenceParameters();
        this.referenceProperties = epr.getReferenceProperties();
        this.from = null;
        this.replyTo = null;
        this.faultTo = null;
    }

    public URI getTo() {
        return this.to;
    }

    public EndpointReference getFrom() {
        return this.from;
    }

    public EndpointReference getReplyTo() {
        return this.replyTo;
    }

    public EndpointReference getFaultTo() {
        return this.faultTo;
    }

    public URI getAction() {
        return this.action;
    }

    public URI getMessageId() {
        return this.messageId;
    }

    public URI getRelatesTo() {
        return this.relatesTo;
    }

    public List getReferenceProperties() {
        return Collections.unmodifiableList(this.referenceProperties);
    }

    public List getReferenceParameters() {
        return Collections.unmodifiableList(this.referenceParameters);
    }

    public MessageAddressingProperties getReplyProperties(EndpointReference epr, URI action, URI messageId) {
        return new MessageAddressingProperties(epr, action, messageId, this.messageId);
    }
}

