/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MIMEOutputUtils;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.soap.SOAPProcessingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.soap.AbstractSoapMessage;
import org.springframework.ws.soap.SoapEnvelope;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.axiom.AxiomAttachment;
import org.springframework.ws.soap.axiom.AxiomSoapEnvelope;
import org.springframework.ws.soap.axiom.AxiomSoapEnvelopeException;
import org.springframework.ws.soap.axiom.AxiomSoapMessageException;
import org.springframework.ws.soap.support.SoapUtils;
import org.springframework.ws.transport.TransportOutputStream;

public class AxiomSoapMessage
extends AbstractSoapMessage {
    private static final String EMPTY_SOAP_ACTION = "\"\"";
    private SOAPMessage axiomMessage;
    private final SOAPFactory axiomFactory;
    private final Attachments attachments;
    private final boolean payloadCaching;
    private AxiomSoapEnvelope envelope;
    private String soapAction;
    private final boolean langAttributeOnSoap11FaultString;
    private OMOutputFormat outputFormat;

    public AxiomSoapMessage(SOAPFactory soapFactory) {
        this(soapFactory, true, true);
    }

    public AxiomSoapMessage(SOAPFactory soapFactory, boolean payloadCaching, boolean langAttributeOnSoap11FaultString) {
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        this.axiomFactory = soapFactory;
        this.axiomMessage = this.axiomFactory.createSOAPMessage(soapEnvelope, soapEnvelope.getBuilder());
        this.attachments = new Attachments();
        this.payloadCaching = payloadCaching;
        this.langAttributeOnSoap11FaultString = langAttributeOnSoap11FaultString;
        this.soapAction = EMPTY_SOAP_ACTION;
    }

    public AxiomSoapMessage(SOAPMessage soapMessage, String soapAction, boolean payloadCaching, boolean langAttributeOnSoap11FaultString) {
        this(soapMessage, new Attachments(), soapAction, payloadCaching, langAttributeOnSoap11FaultString);
    }

    public AxiomSoapMessage(SOAPMessage soapMessage, Attachments attachments, String soapAction, boolean payloadCaching, boolean langAttributeOnSoap11FaultString) {
        Assert.notNull((Object)soapMessage, (String)"'soapMessage' must not be null");
        Assert.notNull((Object)attachments, (String)"'attachments' must not be null");
        this.axiomMessage = soapMessage;
        this.axiomFactory = (SOAPFactory)soapMessage.getSOAPEnvelope().getOMFactory();
        this.attachments = attachments;
        if (!StringUtils.hasLength((String)soapAction)) {
            soapAction = EMPTY_SOAP_ACTION;
        }
        this.soapAction = soapAction;
        this.payloadCaching = payloadCaching;
        this.langAttributeOnSoap11FaultString = langAttributeOnSoap11FaultString;
    }

    public final SOAPMessage getAxiomMessage() {
        return this.axiomMessage;
    }

    public final void setAxiomMessage(SOAPMessage axiomMessage) {
        Assert.notNull((Object)axiomMessage, (String)"'axiomMessage' must not be null");
        this.axiomMessage = axiomMessage;
        this.envelope = null;
        this.soapAction = EMPTY_SOAP_ACTION;
    }

    public void setOutputFormat(OMOutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public SoapEnvelope getEnvelope() {
        if (this.envelope == null) {
            try {
                this.envelope = new AxiomSoapEnvelope(this.axiomMessage.getSOAPEnvelope(), this.axiomFactory, this.payloadCaching, this.langAttributeOnSoap11FaultString);
            }
            catch (SOAPProcessingException ex) {
                throw new AxiomSoapEnvelopeException(ex);
            }
        }
        return this.envelope;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction = SoapUtils.escapeAction(soapAction);
    }

    public boolean isXopPackage() {
        try {
            return "application/xop+xml".equals(this.attachments.getAttachmentSpecType());
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public boolean convertToXopPackage() {
        return false;
    }

    public Attachment getAttachment(String contentId) {
        DataHandler dataHandler;
        Assert.hasLength((String)contentId, (String)"contentId must not be empty");
        if (contentId.startsWith("<") && contentId.endsWith(">")) {
            contentId = contentId.substring(1, contentId.length() - 1);
        }
        return (dataHandler = this.attachments.getDataHandler(contentId)) != null ? new AxiomAttachment(contentId, dataHandler) : null;
    }

    public Iterator getAttachments() {
        return new AxiomAttachmentIterator();
    }

    public Attachment addAttachment(String contentId, DataHandler dataHandler) {
        Assert.hasLength((String)contentId, (String)"contentId must not be empty");
        Assert.notNull((Object)dataHandler, (String)"dataHandler must not be null");
        this.attachments.addDataHandler(contentId, dataHandler);
        return new AxiomAttachment(contentId, dataHandler);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            OMOutputFormat outputFormat = this.getOutputFormat();
            if (outputStream instanceof TransportOutputStream) {
                SoapVersion version;
                TransportOutputStream transportOutputStream = (TransportOutputStream)outputStream;
                String contentType = outputFormat.getContentType();
                if (!outputFormat.isDoingSWA() && !outputFormat.isOptimized()) {
                    String charsetEncoding = this.axiomMessage.getCharsetEncoding();
                    contentType = contentType + "; charset=" + charsetEncoding;
                }
                if (SoapVersion.SOAP_11 == (version = this.getVersion())) {
                    transportOutputStream.addHeader("SOAPAction", this.soapAction);
                    transportOutputStream.addHeader("Accept", version.getContentType());
                } else if (SoapVersion.SOAP_12 == version) {
                    contentType = contentType + "; action=" + this.soapAction;
                    transportOutputStream.addHeader("Accept", version.getContentType());
                }
                transportOutputStream.addHeader("Content-Type", contentType);
            }
            if (!outputFormat.isOptimized() & outputFormat.isDoingSWA()) {
                this.writeSwAMessage(outputStream, outputFormat);
            } else if (this.payloadCaching) {
                this.axiomMessage.serialize(outputStream, outputFormat);
            } else {
                this.axiomMessage.serializeAndConsume(outputStream, outputFormat);
            }
            outputStream.flush();
        }
        catch (XMLStreamException ex) {
            throw new AxiomSoapMessageException("Could not write message to OutputStream: " + ex.getMessage(), ex);
        }
        catch (OMException ex) {
            throw new AxiomSoapMessageException("Could not write message to OutputStream: " + ex.getMessage(), ex);
        }
    }

    private OMOutputFormat getOutputFormat() {
        if (this.outputFormat != null) {
            return this.outputFormat;
        }
        String charsetEncoding = this.axiomMessage.getCharsetEncoding();
        OMOutputFormat outputFormat = new OMOutputFormat();
        outputFormat.setCharSetEncoding(charsetEncoding);
        outputFormat.setSOAP11(this.getVersion() == SoapVersion.SOAP_11);
        if (this.isXopPackage()) {
            outputFormat.setDoOptimize(true);
        } else if (!this.attachments.getContentIDSet().isEmpty()) {
            outputFormat.setDoingSWA(true);
        }
        return outputFormat;
    }

    private void writeSwAMessage(OutputStream outputStream, OMOutputFormat format) throws XMLStreamException, UnsupportedEncodingException {
        StringWriter writer = new StringWriter();
        SOAPEnvelope envelope = this.axiomMessage.getSOAPEnvelope();
        if (this.payloadCaching) {
            envelope.serialize((Writer)writer, format);
        } else {
            envelope.serializeAndConsume((Writer)writer, format);
        }
        MIMEOutputUtils.writeSOAPWithAttachmentsMessage((StringWriter)writer, (OutputStream)outputStream, (Attachments)this.attachments, (OMOutputFormat)format);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("AxiomSoapMessage");
        if (this.payloadCaching) {
            try {
                OMElement bodyElement;
                SOAPBody body;
                SOAPEnvelope envelope = this.axiomMessage.getSOAPEnvelope();
                if (envelope != null && (body = envelope.getBody()) != null && (bodyElement = body.getFirstElement()) != null) {
                    buffer.append(' ');
                    buffer.append(bodyElement.getQName());
                }
            }
            catch (OMException oMException) {
                // empty catch block
            }
        }
        return buffer.toString();
    }

    private class AxiomAttachmentIterator
    implements Iterator {
        private final Iterator iterator;

        private AxiomAttachmentIterator() {
            this.iterator = AxiomSoapMessage.this.attachments.getContentIDSet().iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            String contentId = (String)this.iterator.next();
            DataHandler dataHandler = AxiomSoapMessage.this.attachments.getDataHandler(contentId);
            return new AxiomAttachment(contentId, dataHandler);
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

