/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFaultElement;
import javax.xml.transform.Result;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapFaultDetail;
import org.springframework.ws.soap.SoapFaultDetailElement;
import org.springframework.ws.soap.saaj.SaajSoapElement;
import org.springframework.ws.soap.saaj.SaajSoapFaultDetailElement;
import org.springframework.ws.soap.saaj.SaajSoapFaultException;

class SaajSoapFaultDetail
extends SaajSoapElement
implements SoapFaultDetail {
    public SaajSoapFaultDetail(SOAPFaultElement faultElement) {
        super((SOAPElement)faultElement);
    }

    public Result getResult() {
        return this.getImplementation().getResult((SOAPElement)this.getSaajDetail());
    }

    public SoapFaultDetailElement addFaultDetailElement(QName name) {
        try {
            DetailEntry detailEntry = this.getImplementation().addDetailEntry(this.getSaajDetail(), name);
            return new SaajSoapFaultDetailElement(detailEntry);
        }
        catch (SOAPException ex) {
            throw new SaajSoapFaultException(ex);
        }
    }

    public Iterator getDetailEntries() {
        Iterator iterator = this.getImplementation().getDetailEntries(this.getSaajDetail());
        return new SaajSoapFaultDetailElementIterator(iterator);
    }

    protected Detail getSaajDetail() {
        return (Detail)this.getSaajElement();
    }

    private static class SaajSoapFaultDetailElementIterator
    implements Iterator {
        private final Iterator iterator;

        private SaajSoapFaultDetailElementIterator(Iterator iterator) {
            Assert.notNull((Object)iterator, (String)"No iterator given");
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            DetailEntry saajDetailEntry = (DetailEntry)this.iterator.next();
            return new SaajSoapFaultDetailElement(saajDetailEntry);
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

