/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.mime.AttachmentException;
import org.springframework.ws.soap.AbstractSoapMessage;
import org.springframework.ws.soap.SoapEnvelope;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.Saaj11Implementation;
import org.springframework.ws.soap.saaj.Saaj12Implementation;
import org.springframework.ws.soap.saaj.Saaj13Implementation;
import org.springframework.ws.soap.saaj.SaajAttachment;
import org.springframework.ws.soap.saaj.SaajImplementation;
import org.springframework.ws.soap.saaj.SaajSoapEnvelope;
import org.springframework.ws.soap.saaj.SaajSoapEnvelopeException;
import org.springframework.ws.soap.saaj.SaajSoapMessageException;
import org.springframework.ws.soap.saaj.support.SaajUtils;
import org.springframework.ws.soap.support.SoapUtils;

public class SaajSoapMessage
extends AbstractSoapMessage {
    private static final String CONTENT_TYPE_XOP = "application/xop+xml";
    private SOAPMessage saajMessage;
    private SoapEnvelope envelope;
    private final boolean langAttributeOnSoap11FaultString;
    private SaajImplementation implementation;

    public SaajSoapMessage(SOAPMessage soapMessage) {
        this(soapMessage, true);
    }

    public SaajSoapMessage(SOAPMessage soapMessage, boolean langAttributeOnSoap11FaultString) {
        Assert.notNull((Object)soapMessage, (String)"soapMessage must not be null");
        this.saajMessage = soapMessage;
        this.langAttributeOnSoap11FaultString = langAttributeOnSoap11FaultString;
        MimeHeaders headers = this.getImplementation().getMimeHeaders(soapMessage);
        if (ObjectUtils.isEmpty((Object[])headers.getHeader("SOAPAction"))) {
            headers.addHeader("SOAPAction", "\"\"");
        }
    }

    public SOAPMessage getSaajMessage() {
        return this.saajMessage;
    }

    public void setSaajMessage(SOAPMessage soapMessage) {
        Assert.notNull((Object)soapMessage, (String)"soapMessage must not be null");
        this.saajMessage = soapMessage;
        this.envelope = null;
    }

    public SoapEnvelope getEnvelope() {
        if (this.envelope == null) {
            try {
                SOAPEnvelope saajEnvelope = this.getImplementation().getEnvelope(this.getSaajMessage());
                this.envelope = new SaajSoapEnvelope((SOAPElement)saajEnvelope, this.langAttributeOnSoap11FaultString);
            }
            catch (SOAPException ex) {
                throw new SaajSoapEnvelopeException(ex);
            }
        }
        return this.envelope;
    }

    public String getSoapAction() {
        MimeHeaders mimeHeaders = this.getImplementation().getMimeHeaders(this.getSaajMessage());
        if (SoapVersion.SOAP_11 == this.getVersion()) {
            Object[] actions = mimeHeaders.getHeader("SOAPAction");
            return ObjectUtils.isEmpty((Object[])actions) ? "\"\"" : actions[0];
        }
        if (SoapVersion.SOAP_12 == this.getVersion()) {
            Object[] contentTypes = mimeHeaders.getHeader("Content-Type");
            return !ObjectUtils.isEmpty((Object[])contentTypes) ? SoapUtils.extractActionFromContentType((String)contentTypes[0]) : "\"\"";
        }
        throw new IllegalStateException("Unsupported SOAP version: " + this.getVersion());
    }

    public void setSoapAction(String soapAction) {
        MimeHeaders mimeHeaders = this.getImplementation().getMimeHeaders(this.getSaajMessage());
        soapAction = SoapUtils.escapeAction(soapAction);
        if (SoapVersion.SOAP_11 == this.getVersion()) {
            mimeHeaders.setHeader("SOAPAction", soapAction);
        } else if (SoapVersion.SOAP_12 == this.getVersion()) {
            Object[] contentTypes;
            if (this.saajMessage.saveRequired()) {
                try {
                    this.saajMessage.saveChanges();
                }
                catch (SOAPException ex) {
                    throw new SaajSoapMessageException("Could not save message", ex);
                }
            }
            Object contentType = !ObjectUtils.isEmpty((Object[])(contentTypes = mimeHeaders.getHeader("Content-Type"))) ? contentTypes[0] : this.getVersion().getContentType();
            contentType = SoapUtils.setActionInContentType((String)contentType, soapAction);
            mimeHeaders.setHeader("Content-Type", (String)contentType);
            mimeHeaders.removeHeader("SOAPAction");
        } else {
            throw new IllegalStateException("Unsupported SOAP version: " + this.getVersion());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        MimeHeaders mimeHeaders = this.getImplementation().getMimeHeaders(this.getSaajMessage());
        if (ObjectUtils.isEmpty((Object[])mimeHeaders.getHeader("Accept"))) {
            mimeHeaders.setHeader("Accept", this.getVersion().getContentType());
        }
        try {
            this.getImplementation().writeTo(this.getSaajMessage(), outputStream);
            outputStream.flush();
        }
        catch (SOAPException ex) {
            throw new SaajSoapMessageException("Could not write message to OutputStream: " + ex.getMessage(), ex);
        }
    }

    public boolean isXopPackage() {
        if (SaajUtils.getSaajVersion(this.saajMessage) >= 2) {
            SOAPPart saajPart = this.saajMessage.getSOAPPart();
            String[] contentTypes = saajPart.getMimeHeader("Content-Type");
            for (int i = 0; i < contentTypes.length; ++i) {
                if (contentTypes[i].indexOf(CONTENT_TYPE_XOP) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean convertToXopPackage() {
        if (SaajUtils.getSaajVersion(this.saajMessage) >= 2) {
            this.convertMessageToXop();
            this.convertPartToXop();
            return true;
        }
        return false;
    }

    private void convertMessageToXop() {
        MimeHeaders mimeHeaders = this.saajMessage.getMimeHeaders();
        Object[] oldContentTypes = mimeHeaders.getHeader("Content-Type");
        Object oldContentType = !ObjectUtils.isEmpty((Object[])oldContentTypes) ? oldContentTypes[0] : this.getVersion().getContentType();
        StringBuffer buffer = new StringBuffer(CONTENT_TYPE_XOP);
        buffer.append(";type=");
        buffer.append('\"');
        buffer.append((String)oldContentType);
        buffer.append('\"');
        mimeHeaders.setHeader("Content-Type", buffer.toString());
    }

    private void convertPartToXop() {
        SOAPPart saajPart = this.saajMessage.getSOAPPart();
        Object[] oldContentTypes = saajPart.getMimeHeader("Content-Type");
        Object oldContentType = !ObjectUtils.isEmpty((Object[])oldContentTypes) ? oldContentTypes[0] : this.getVersion().getContentType();
        StringBuffer buffer = new StringBuffer(CONTENT_TYPE_XOP);
        buffer.append(";type=");
        buffer.append('\"');
        buffer.append((String)oldContentType);
        buffer.append('\"');
        saajPart.setMimeHeader("Content-Type", buffer.toString());
    }

    public Iterator getAttachments() throws AttachmentException {
        Iterator iterator = this.getImplementation().getAttachments(this.getSaajMessage());
        return new SaajAttachmentIterator(iterator);
    }

    public Attachment getAttachment(String contentId) {
        Assert.hasLength((String)contentId, (String)"contentId must not be empty");
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.setHeader("Content-Id", contentId);
        Iterator iterator = this.getImplementation().getAttachment(this.getSaajMessage(), mimeHeaders);
        if (!iterator.hasNext()) {
            return null;
        }
        AttachmentPart saajAttachment = (AttachmentPart)iterator.next();
        return new SaajAttachment(saajAttachment);
    }

    public Attachment addAttachment(String contentId, DataHandler dataHandler) {
        Assert.hasLength((String)contentId, (String)"contentId must not be empty");
        Assert.notNull((Object)dataHandler, (String)"dataHandler must not be null");
        AttachmentPart saajAttachment = this.getImplementation().addAttachmentPart(this.getSaajMessage(), dataHandler);
        saajAttachment.setContentId(contentId);
        saajAttachment.setMimeHeader("Content-Transfer-Encoding", "binary");
        return new SaajAttachment(saajAttachment);
    }

    protected final SaajImplementation getImplementation() {
        if (this.implementation == null) {
            if (SaajUtils.getSaajVersion(this.saajMessage) == 2) {
                this.implementation = Saaj13Implementation.getInstance();
            } else if (SaajUtils.getSaajVersion(this.saajMessage) == 1) {
                this.implementation = Saaj12Implementation.getInstance();
            } else if (SaajUtils.getSaajVersion(this.saajMessage) == 0) {
                this.implementation = Saaj11Implementation.getInstance();
            } else {
                throw new IllegalStateException("Could not find SAAJ on the classpath");
            }
        }
        return this.implementation;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("SaajSoapMessage");
        try {
            SOAPElement bodyElement;
            SOAPBody body;
            SOAPEnvelope envelope = this.getImplementation().getEnvelope(this.saajMessage);
            if (envelope != null && (body = this.getImplementation().getBody(envelope)) != null && (bodyElement = this.getImplementation().getFirstBodyElement(body)) != null) {
                buffer.append(' ');
                buffer.append(this.getImplementation().getName(bodyElement));
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return buffer.toString();
    }

    private static class SaajAttachmentIterator
    implements Iterator {
        private final Iterator saajIterator;

        private SaajAttachmentIterator(Iterator saajIterator) {
            this.saajIterator = saajIterator;
        }

        public boolean hasNext() {
            return this.saajIterator.hasNext();
        }

        public Object next() {
            AttachmentPart saajAttachment = (AttachmentPart)this.saajIterator.next();
            return new SaajAttachment(saajAttachment);
        }

        public void remove() {
            this.saajIterator.remove();
        }
    }
}

