/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.transport.AbstractSenderConnection;
import org.springframework.ws.transport.FaultAwareWebServiceConnection;

public abstract class AbstractHttpSenderConnection
extends AbstractSenderConnection
implements FaultAwareWebServiceConnection {
    private byte[] responseBuffer;

    public final boolean hasError() throws IOException {
        return this.getResponseCode() / 100 != 2;
    }

    public final String getErrorMessage() throws IOException {
        StringBuffer buffer = new StringBuffer();
        String responseMessage = this.getResponseMessage();
        if (StringUtils.hasLength((String)responseMessage)) {
            buffer.append(responseMessage);
        }
        buffer.append(" [");
        buffer.append(this.getResponseCode());
        buffer.append(']');
        return buffer.toString();
    }

    protected final boolean hasResponse() throws IOException {
        int responseCode = this.getResponseCode();
        if (202 == responseCode || 204 == responseCode) {
            return false;
        }
        long contentLength = this.getResponseContentLength();
        if (contentLength < 0L) {
            if (this.responseBuffer == null) {
                this.responseBuffer = FileCopyUtils.copyToByteArray((InputStream)this.getRawResponseInputStream());
            }
            contentLength = this.responseBuffer.length;
        }
        return contentLength > 0L;
    }

    protected final InputStream getResponseInputStream() throws IOException {
        InputStream inputStream = this.responseBuffer != null ? new ByteArrayInputStream(this.responseBuffer) : this.getRawResponseInputStream();
        return this.isGzipResponse() ? new GZIPInputStream(inputStream) : inputStream;
    }

    private boolean isGzipResponse() throws IOException {
        Iterator iterator = this.getResponseHeaders("Content-Encoding");
        if (iterator.hasNext()) {
            String encodingHeader = (String)iterator.next();
            return encodingHeader.toLowerCase().indexOf("gzip") != -1;
        }
        return false;
    }

    protected abstract int getResponseCode() throws IOException;

    protected abstract String getResponseMessage() throws IOException;

    protected abstract long getResponseContentLength() throws IOException;

    protected abstract InputStream getRawResponseInputStream() throws IOException;

    public final boolean hasFault() throws IOException {
        return 500 == this.getResponseCode() && this.isXmlResponse();
    }

    private boolean isXmlResponse() throws IOException {
        Iterator iterator = this.getResponseHeaders("Content-Type");
        if (iterator.hasNext()) {
            String contentType = ((String)iterator.next()).toLowerCase();
            return contentType.indexOf("xml") != -1;
        }
        return false;
    }

    public final void setFault(boolean fault) {
    }
}

