/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.support;

import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.FaultAwareWebServiceMessage;
import org.springframework.ws.NoEndpointFoundException;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.context.DefaultMessageContext;
import org.springframework.ws.transport.EndpointAwareWebServiceConnection;
import org.springframework.ws.transport.FaultAwareWebServiceConnection;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageReceiver;
import org.springframework.ws.transport.context.DefaultTransportContext;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.ws.transport.support.TransportUtils;

public abstract class WebServiceMessageReceiverObjectSupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private WebServiceMessageFactory messageFactory;

    public WebServiceMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(WebServiceMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.messageFactory, (String)"messageFactory is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleConnection(WebServiceConnection connection, WebServiceMessageReceiver receiver) throws Exception {
        this.logUri(connection);
        TransportContext previousTransportContext = TransportContextHolder.getTransportContext();
        TransportContextHolder.setTransportContext(new DefaultTransportContext(connection));
        try {
            WebServiceMessage request = connection.receive(this.getMessageFactory());
            DefaultMessageContext messageContext = new DefaultMessageContext(request, this.getMessageFactory());
            receiver.receive(messageContext);
            if (messageContext.hasResponse()) {
                WebServiceMessage response = messageContext.getResponse();
                if (response instanceof FaultAwareWebServiceMessage && connection instanceof FaultAwareWebServiceConnection) {
                    FaultAwareWebServiceMessage faultResponse = (FaultAwareWebServiceMessage)response;
                    FaultAwareWebServiceConnection faultConnection = (FaultAwareWebServiceConnection)connection;
                    faultConnection.setFault(faultResponse.hasFault());
                }
                connection.send(messageContext.getResponse());
            }
        }
        catch (NoEndpointFoundException ex) {
            if (connection instanceof EndpointAwareWebServiceConnection) {
                ((EndpointAwareWebServiceConnection)connection).endpointNotFound();
            }
        }
        finally {
            TransportUtils.closeConnection(connection);
            TransportContextHolder.setTransportContext(previousTransportContext);
        }
    }

    private void logUri(WebServiceConnection connection) {
        if (this.logger.isDebugEnabled()) {
            try {
                this.logger.debug((Object)("Accepting incoming [" + connection + "] to [" + connection.getUri() + "]"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }
}

