/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms;

import javax.ejb.EJBException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.naming.NamingException;
import org.springframework.ejb.support.AbstractJmsMessageDrivenBean;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jndi.JndiLookupFailureException;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.transport.WebServiceMessageReceiver;
import org.springframework.ws.transport.jms.JmsMessageReceiver;
import org.springframework.ws.transport.jms.JmsTransportException;

public class WebServiceMessageDrivenBean
extends AbstractJmsMessageDrivenBean {
    public static final String CONNECTION_FACTORY_BEAN_NAME = "connectionFactory";
    public static final String MESSAGE_FACTORY_BEAN_NAME = "messageFactory";
    public static final String MESSAGE_RECEIVER_BEAN_NAME = "messageReceiver";
    private JmsMessageReceiver delegate;
    private ConnectionFactory connectionFactory;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message message) {
        Connection connection = null;
        Session session = null;
        try {
            connection = this.createConnection(this.connectionFactory);
            session = this.createSession(connection);
            this.delegate.handleMessage(message, session);
        }
        catch (JmsTransportException ex) {
            try {
                throw JmsUtils.convertJmsAccessException((JMSException)ex.getJmsException());
                catch (JMSException ex2) {
                    throw JmsUtils.convertJmsAccessException((JMSException)ex2);
                }
                catch (Exception ex3) {
                    throw new EJBException(ex3);
                }
            }
            catch (Throwable throwable) {
                JmsUtils.closeSession(session);
                ConnectionFactoryUtils.releaseConnection((Connection)connection, (ConnectionFactory)this.connectionFactory, (boolean)true);
                throw throwable;
            }
        }
        JmsUtils.closeSession((Session)session);
        ConnectionFactoryUtils.releaseConnection((Connection)connection, (ConnectionFactory)this.connectionFactory, (boolean)true);
    }

    protected void onEjbCreate() {
        try {
            this.connectionFactory = this.createConnectionFactory();
            this.delegate = new JmsMessageReceiver();
            this.delegate.setMessageFactory(this.createMessageFactory());
            this.delegate.setMessageReceiver(this.createMessageReceiver());
            this.delegate.setPostProcessor(this.createPostProcessor());
        }
        catch (NamingException ex) {
            throw new JndiLookupFailureException("Could not create connection", ex);
        }
        catch (JMSException ex) {
            throw JmsUtils.convertJmsAccessException((JMSException)ex);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return (ConnectionFactory)this.getBeanFactory().getBean(CONNECTION_FACTORY_BEAN_NAME, ConnectionFactory.class);
    }

    protected WebServiceMessageFactory createMessageFactory() {
        return (WebServiceMessageFactory)this.getBeanFactory().getBean(MESSAGE_FACTORY_BEAN_NAME, WebServiceMessageFactory.class);
    }

    protected WebServiceMessageReceiver createMessageReceiver() {
        return (WebServiceMessageReceiver)this.getBeanFactory().getBean(MESSAGE_RECEIVER_BEAN_NAME, WebServiceMessageReceiver.class);
    }

    protected Connection createConnection(ConnectionFactory connectionFactory) throws JMSException {
        return connectionFactory.createConnection();
    }

    protected Session createSession(Connection connection) throws JMSException {
        return connection.createSession(false, 1);
    }

    protected MessagePostProcessor createPostProcessor() {
        return null;
    }
}

