/*
 * Decompiled with CFR 0.152.
 */
package org.statefulj.fsm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.statefulj.fsm.Persister;
import org.statefulj.fsm.RetryException;
import org.statefulj.fsm.StaleStateException;
import org.statefulj.fsm.TooBusyException;
import org.statefulj.fsm.WaitAndRetryException;
import org.statefulj.fsm.model.Action;
import org.statefulj.fsm.model.State;
import org.statefulj.fsm.model.StateActionPair;
import org.statefulj.fsm.model.Transition;
import org.statefulj.fsm.model.impl.DeterministicTransitionImpl;
import org.statefulj.fsm.model.impl.StateImpl;
import org.statefulj.persistence.memory.MemoryPersisterImpl;

public class FSM<T> {
    private static final Logger logger = LoggerFactory.getLogger(FSM.class);
    private static final int DEFAULT_RETRIES = 20;
    private static final int DEFAULT_RETRY_INTERVAL = 250;
    private int retryAttempts = 20;
    private int retryInterval = 250;
    private Persister<T> persister;
    private String name = "FSM";

    public FSM(String name) {
        this.name = name;
    }

    public FSM(Persister<T> persister) {
        this.persister = persister;
    }

    public FSM(String name, Persister<T> persister) {
        this.name = name;
        this.persister = persister;
    }

    public FSM(String name, Persister<T> persister, int retryAttempts, int retryInterval) {
        this.name = name;
        this.persister = persister;
        this.retryAttempts = retryAttempts;
        this.retryInterval = retryInterval;
    }

    public State<T> onEvent(T stateful, String event, Object ... args) throws TooBusyException {
        for (int attempts = 0; this.retryAttempts == -1 || attempts < this.retryAttempts; ++attempts) {
            try {
                State<T> current = this.getCurrentState(stateful);
                Transition<T> transition = this.getTransition(event, current);
                if (transition != null) {
                    current = this.transition(stateful, current, event, transition, args);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}({})::{}({})->{}/noop", new Object[]{this.name, stateful.getClass().getSimpleName(), current.getName(), event, current.getName()});
                    }
                    if (current.isBlocking()) {
                        this.setCurrent(stateful, current, current);
                        throw new WaitAndRetryException(this.retryInterval);
                    }
                }
                return current;
            }
            catch (RetryException re) {
                logger.warn("{}({})::Retrying event", (Object)this.name, stateful);
                if (!WaitAndRetryException.class.isInstance(re)) continue;
                try {
                    Thread.sleep(((WaitAndRetryException)re).getWait());
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
        }
        logger.error("{}({})::Unable to process event", (Object)this.name, stateful);
        throw new TooBusyException();
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setRetryAttempts(int retries) {
        this.retryAttempts = retries;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Persister<T> getPersister() {
        return this.persister;
    }

    public void setPersister(Persister<T> persister) {
        this.persister = persister;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public State<T> getCurrentState(T obj) {
        return this.persister.getCurrent(obj);
    }

    protected Transition<T> getTransition(String event, State<T> current) {
        return current.getTransition(event);
    }

    protected State<T> transition(T stateful, State<T> current, String event, Transition<T> transition, Object ... args) throws RetryException {
        StateActionPair<T> pair = transition.getStateActionPair(stateful, event, args);
        this.setCurrent(stateful, current, pair.getState());
        this.executeAction(pair.getAction(), stateful, event, current.getName(), pair.getState().getName(), args);
        return this.getCurrentState(stateful);
    }

    protected void setCurrent(T stateful, State<T> current, State<T> next) throws StaleStateException {
        this.persister.setCurrent(stateful, current, next);
    }

    protected void executeAction(Action<T> action, T stateful, String event, String from, String to, Object ... args) throws RetryException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}({})::{}({})->{}/{}", new Object[]{this.name, stateful.getClass().getSimpleName(), from, event, to, action == null ? "noop" : action.toString()});
        }
        if (action != null) {
            action.execute(stateful, event, args);
        }
    }

    public static class FSMBuilder<T> {
        private int retryAttempts = 20;
        private int retryInterval = 250;
        private Persister<T> persister;
        private String name = "FSM";
        private HashMap<String, State<T>> states = new HashMap();
        private List<StateBuilder<T>> stateBuilders = new LinkedList<StateBuilder<T>>();
        private String startState;

        public static <T> FSMBuilder<T> newBuilder(Class<T> clazz) {
            return new FSMBuilder<T>();
        }

        public FSMBuilder<T> setPerister(Persister<T> persister) {
            this.persister = persister;
            return this;
        }

        public FSMBuilder<T> setName(String name) {
            this.name = name;
            return this;
        }

        public FSMBuilder<T> setRetryAttempts(int retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        public FSMBuilder<T> setRetryInterval(int retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public FSMBuilder<T> addState(State<T> state) {
            return this.addState(state, false);
        }

        public FSMBuilder<T> addState(State<T> state, boolean isStartState) {
            this.startState = this.startState == null || isStartState ? state.getName() : this.startState;
            this.states.put(state.getName(), state);
            return this;
        }

        public StateBuilder<T> buildState(String name) {
            return this.buildState(name, false);
        }

        public StateBuilder<T> buildState(String name, boolean isStartState) {
            this.startState = this.startState == null || isStartState ? name : this.startState;
            StateBuilder stateBuilder = new StateBuilder(this, name);
            this.stateBuilders.add(stateBuilder);
            return stateBuilder;
        }

        public FSM<T> build() {
            for (StateBuilder<T> stateBuilder : this.stateBuilders) {
                State state = ((StateBuilder)stateBuilder).buildState();
                this.states.put(state.getName(), state);
            }
            for (StateBuilder<T> stateBuilder : this.stateBuilders) {
                ((StateBuilder)stateBuilder).buildTransitions(this.states);
            }
            State<T> startState = this.states.get(this.startState);
            if (startState == null) {
                throw new RuntimeException("No start state defined, state=" + this.startState);
            }
            if (this.persister == null) {
                this.persister = new MemoryPersisterImpl();
            }
            this.persister.setStates(this.states.values());
            this.persister.setStartState(startState);
            return new FSM<T>(this.name, this.persister, this.retryAttempts, this.retryInterval);
        }

        public static class StateBuilder<T> {
            private String stateName;
            private Map<String, Transition<T>> transistions = new HashMap<String, Transition<T>>();
            private List<TransitionBuilder<T>> transistionBuilders = new LinkedList<TransitionBuilder<T>>();
            private boolean isEndState = false;
            private boolean isBlocking = false;
            private State<T> state;
            private FSMBuilder<T> fsmBuilder;

            private StateBuilder(FSMBuilder<T> fsmBuilder, String stateName) {
                if (stateName == null || stateName.trim().equals("")) {
                    throw new RuntimeException("You must provide a State name");
                }
                this.fsmBuilder = fsmBuilder;
                this.stateName = stateName;
            }

            public StateBuilder<T> setEndState(boolean isEndState) {
                this.isEndState = isEndState;
                return this;
            }

            public StateBuilder<T> setBlockingState(boolean isBlocking) {
                this.isBlocking = isBlocking;
                return this;
            }

            public StateBuilder<T> addTransition(String event, String toState) {
                this.transistionBuilders.add(new TransitionBuilder(event, toState));
                return this;
            }

            public StateBuilder<T> addTransition(String event, State<T> toState) {
                return this.addTransition(event, toState, null);
            }

            public StateBuilder<T> addTransition(String event, String toState, Action<T> action) {
                this.transistionBuilders.add(new TransitionBuilder(event, toState, action));
                return this;
            }

            public StateBuilder<T> addTransition(String event, State<T> toState, Action<T> action) {
                this.fsmBuilder.addState(toState);
                this.transistionBuilders.add(new TransitionBuilder(event, toState, action));
                return this;
            }

            public StateBuilder<T> addTransition(String event, Action<T> action) {
                return this.addTransition(event, this.stateName, action);
            }

            public StateBuilder<T> addTransition(String event, Transition<T> transition) {
                this.transistions.put(event, transition);
                return this;
            }

            public TransitionBuilder<T> buildTransition(String event) {
                TransitionBuilder transitionBuilder = new TransitionBuilder(event, this);
                this.transistionBuilders.add(transitionBuilder);
                return transitionBuilder;
            }

            public FSMBuilder<T> done() {
                return this.fsmBuilder;
            }

            private State<T> buildState() {
                this.state = new StateImpl<T>(this.stateName, this.transistions, this.isEndState, this.isBlocking);
                return this.state;
            }

            private void buildTransitions(Map<String, State<T>> states) {
                for (TransitionBuilder<T> transitionBuilder : this.transistionBuilders) {
                    ((TransitionBuilder)transitionBuilder).build(this.state, states);
                }
            }

            public static class TransitionBuilder<T> {
                private StateBuilder<T> stateBuilder;
                private String event;
                private String toStateName;
                private State<T> toState;
                private Action<T> action;

                private TransitionBuilder(String event, StateBuilder<T> stateBuilder) {
                    this.event = event;
                    this.stateBuilder = stateBuilder;
                    this.toStateName = null;
                    this.action = null;
                }

                private TransitionBuilder(String event, String toStateKey) {
                    this(event, toStateKey, (Action<T>)null);
                }

                private TransitionBuilder(String event, String toStateKey, Action<T> action) {
                    if (event == null || event.trim().equals("")) {
                        throw new RuntimeException("You must provide an Event");
                    }
                    this.event = event;
                    this.toStateName = toStateKey;
                    this.toState = null;
                    this.action = action;
                }

                private TransitionBuilder(String event, State<T> toState, Action<T> action) {
                    if (event == null || event.trim().equals("")) {
                        throw new RuntimeException("You must provide an Event");
                    }
                    this.event = event;
                    this.toState = toState;
                    this.action = action;
                }

                public TransitionBuilder<T> setToState(String toStateName) {
                    this.toStateName = toStateName;
                    return this;
                }

                public TransitionBuilder<T> setToState(State<T> toState) {
                    this.toState = toState;
                    return this;
                }

                public TransitionBuilder<T> setAction(Action<T> action) {
                    this.action = action;
                    return this;
                }

                public StateBuilder<T> done() {
                    return this.stateBuilder;
                }

                private Transition<T> build(State<T> from, Map<String, State<T>> states) {
                    State<T> to = this.toState != null ? this.toState : (this.toStateName != null ? states.get(this.toStateName) : from);
                    return new DeterministicTransitionImpl<T>(from, to, this.event, this.action);
                }
            }
        }
    }
}

