/*
 * Decompiled with CFR 0.152.
 */
package org.staxnav;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import org.staxnav.AbstractXMLTestCase;
import org.staxnav.Axis;
import org.staxnav.Naming;
import org.staxnav.StaxNavigator;
import org.staxnav.StaxNavigatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBrowseTestCase<N>
extends AbstractXMLTestCase {
    private StaxNavigator<N> navigator;
    private Naming<N> naming;

    protected abstract Naming<N> getNaming();

    protected void setUp() throws Exception {
        Naming<N> naming = this.getNaming();
        InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream("sample.xml");
        this.navigator = StaxNavigatorFactory.create(naming, (InputStream)is);
        this.naming = naming;
    }

    protected final StaxNavigator<N> navigator(String document) {
        return this.navigator(this.naming, document);
    }

    protected N createName(String localPart) {
        return (N)this.naming.getName(null, null, localPart);
    }

    public final void assertNameEquals(String expectedLocalPart, N name) {
        N expectedName = this.createName(expectedLocalPart);
        AbstractBrowseTestCase.assertEquals(expectedName, name);
    }

    public void testInit() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)1, (int)this.navigator.getDepth());
    }

    public void testContent() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        this.assertNameEquals("bar1", this.navigator.child());
        AbstractBrowseTestCase.assertEquals((String)"1", (String)this.navigator.getContent());
        this.assertNameEquals("foo2", this.navigator.sibling());
        this.assertNameEquals("bar2", this.navigator.child());
        AbstractBrowseTestCase.assertEquals((String)"2", (String)this.navigator.getContent());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.sibling(this.createName("bar3")));
        this.assertNameEquals("foo3", this.navigator.child());
        AbstractBrowseTestCase.assertEquals((String)"4", (String)this.navigator.getContent());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.find(this.createName("foobar1")));
        AbstractBrowseTestCase.assertEquals((String)"3", (String)this.navigator.getContent());
    }

    public void testChild() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        this.assertNameEquals("bar1", this.navigator.child());
        this.assertNameEquals("bar1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)2, (int)this.navigator.getDepth());
    }

    public void testChildWithName() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.child(this.createName("foobar1")));
        this.assertNameEquals("foobar1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)2, (int)this.navigator.getDepth());
    }

    public void testChildOver() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        this.assertNameEquals("bar1", this.navigator.child());
        AbstractBrowseTestCase.assertNull((Object)this.navigator.child());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.sibling(this.createName("foobar1")));
        this.assertNameEquals("foobar2", this.navigator.sibling());
    }

    public void testChildWithNameOver() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.child(this.createName("foo2")));
        AbstractBrowseTestCase.assertFalse((boolean)this.navigator.child(this.createName("donotexist")));
        this.assertNameEquals("foo2", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)2, (int)this.navigator.getDepth());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.sibling(this.createName("foobar1")));
        this.assertNameEquals("foobar2", this.navigator.sibling());
    }

    public void testsibling() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        this.assertNameEquals("bar1", this.navigator.child());
        this.assertNameEquals("foo2", this.navigator.sibling());
        this.assertNameEquals("foo2", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)2, (int)this.navigator.getDepth());
        this.assertNameEquals("foobar1", this.navigator.sibling());
        this.assertNameEquals("foobar1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)2, (int)this.navigator.getDepth());
    }

    public void testsiblingWithName() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        this.assertNameEquals("bar1", this.navigator.child());
        AbstractBrowseTestCase.assertEquals((int)2, (int)this.navigator.getDepth());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.sibling(this.createName("foobar1")));
        this.assertNameEquals("foobar1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)2, (int)this.navigator.getDepth());
    }

    public void testsiblingOver() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.child(this.createName("foo2")));
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.child(this.createName("bar3")));
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.child(this.createName("foo3")));
        AbstractBrowseTestCase.assertNull((Object)this.navigator.sibling());
    }

    public void testsiblingWithNameOver() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.child(this.createName("foo2")));
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.child(this.createName("bar2")));
    }

    public void testsiblingEOF() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.child(this.createName("foo2")));
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.child(this.createName("bar2")));
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.find(this.createName("foobar2")));
        AbstractBrowseTestCase.assertNull((Object)this.navigator.sibling());
        this.assertNameEquals("foobar2", this.navigator.getName());
    }

    public void testsiblingWithNameEOF() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.child(this.createName("foo2")));
        this.assertNameEquals("foo2", this.navigator.getName());
        AbstractBrowseTestCase.assertFalse((boolean)this.navigator.sibling(this.createName("donotexist")));
        this.assertNameEquals("foo2", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)2, (int)this.navigator.getDepth());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.sibling(this.createName("foobar1")));
        this.assertNameEquals("foobar1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((String)"3", (String)this.navigator.getContent());
        AbstractBrowseTestCase.assertEquals((int)2, (int)this.navigator.getDepth());
        this.assertNameEquals("foobar2", this.navigator.sibling());
    }

    public void testAttribute() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        this.navigator.child();
        this.navigator.sibling();
        this.navigator.child();
        this.assertNameEquals("bar2", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((String)"b", (String)this.navigator.getAttribute("a"));
        AbstractBrowseTestCase.assertEquals((String)"c", (String)this.navigator.getAttribute("b"));
        AbstractBrowseTestCase.assertEquals(null, (String)this.navigator.getAttribute("donotexists"));
    }

    public void testAttributeInPushback() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.child(this.createName("foo2")));
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.child(this.createName("bar2")));
        this.assertNameEquals("bar2", this.navigator.getName());
        AbstractBrowseTestCase.assertFalse((boolean)this.navigator.sibling(this.createName("donotexist")));
        this.assertNameEquals("bar2", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)3, (int)this.navigator.getDepth());
        AbstractBrowseTestCase.assertEquals((String)"b", (String)this.navigator.getAttribute("a"));
        AbstractBrowseTestCase.assertEquals((String)"c", (String)this.navigator.getAttribute("b"));
        AbstractBrowseTestCase.assertEquals(null, (String)this.navigator.getAttribute("donotexists"));
    }

    public void testDescendant1() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)-1, (int)this.navigator.descendant(this.createName("foo1")));
    }

    public void testDescendant2() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)1, (int)this.navigator.descendant(this.createName("bar1")));
    }

    public void testDescendant3() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)2, (int)this.navigator.descendant(this.createName("bar2")));
    }

    public void testDescendant4() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((int)-1, (int)this.navigator.descendant(this.createName("blah")));
    }

    public void testNext1() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals(this.createName("bar1"), (Object)this.navigator.next());
        AbstractBrowseTestCase.assertEquals(this.createName("foo2"), (Object)this.navigator.next());
        AbstractBrowseTestCase.assertEquals(this.createName("bar2"), (Object)this.navigator.next());
        AbstractBrowseTestCase.assertEquals(this.createName("bar3"), (Object)this.navigator.next());
        AbstractBrowseTestCase.assertEquals(this.createName("foo3"), (Object)this.navigator.next());
        AbstractBrowseTestCase.assertEquals(this.createName("foobar1"), (Object)this.navigator.next());
        AbstractBrowseTestCase.assertEquals(this.createName("foobar2"), (Object)this.navigator.next());
        AbstractBrowseTestCase.assertEquals(null, (Object)this.navigator.next());
    }

    public void testNext2() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((boolean)false, (boolean)this.navigator.next(this.createName("foo2")));
        AbstractBrowseTestCase.assertEquals(this.createName("bar1"), (Object)this.navigator.next());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.next(this.createName("foo2")));
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.next(this.createName("bar2")));
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.next(this.createName("bar3")));
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.next(this.createName("foo3")));
        AbstractBrowseTestCase.assertEquals(this.createName("foobar1"), (Object)this.navigator.next());
        AbstractBrowseTestCase.assertEquals(this.createName("foobar2"), (Object)this.navigator.next());
    }

    public void testNext3() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        HashSet<N> names = new HashSet<N>();
        names.add(this.createName("bar1"));
        names.add(this.createName("foo2"));
        AbstractBrowseTestCase.assertEquals(this.createName("bar1"), (Object)this.navigator.next(names));
        AbstractBrowseTestCase.assertEquals(this.createName("foo2"), (Object)this.navigator.next(names));
        AbstractBrowseTestCase.assertNull((Object)this.navigator.next(names));
    }

    public void testNext4() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        HashSet<N> names = new HashSet<N>();
        names.add(this.createName("bar1"));
        names.add(this.createName("foo2"));
        names.add(this.createName("bar2"));
        names.add(this.createName("bar3"));
        names.add(this.createName("foo3"));
        names.add(this.createName("foobar1"));
        names.add(this.createName("foobar2"));
        while (this.navigator.next(names) != null) {
        }
        this.assertNameEquals("foobar2", this.navigator.getName());
        AbstractBrowseTestCase.assertNull((Object)this.navigator.next());
    }

    public void testfind1() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.find(this.createName("foo1")));
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.find(this.createName("bar2")));
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.find(this.createName("foobar1")));
    }

    public void testEnd() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.find(this.createName("foobar2")));
        AbstractBrowseTestCase.assertEquals(this.createName("foobar2"), (Object)this.navigator.getName());
        AbstractBrowseTestCase.assertEquals(null, (Object)this.navigator.next());
        AbstractBrowseTestCase.assertEquals(this.createName("foobar2"), (Object)this.navigator.getName());
    }

    public void testFork1() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.find(this.createName("foo2")));
        StaxNavigator fork = this.navigator.fork(Axis.FOLLOWING_SIBLING);
        AbstractBrowseTestCase.assertEquals(this.createName("foo2"), (Object)fork.getName());
        AbstractBrowseTestCase.assertEquals(this.createName("bar2"), (Object)fork.next());
        AbstractBrowseTestCase.assertEquals(this.createName("bar3"), (Object)fork.next());
        AbstractBrowseTestCase.assertEquals(this.createName("foo3"), (Object)fork.next());
        AbstractBrowseTestCase.assertEquals(null, (Object)fork.next());
        this.assertNameEquals("foobar1", this.navigator.getName());
    }

    public void testFork2() throws Exception {
        this.assertNameEquals("foo1", this.navigator.getName());
        AbstractBrowseTestCase.assertEquals((boolean)true, (boolean)this.navigator.find(this.createName("foobar2")));
        StaxNavigator fork = this.navigator.fork(Axis.FOLLOWING_SIBLING);
        this.assertNameEquals("foobar2", fork.getName());
        AbstractBrowseTestCase.assertEquals(null, (Object)fork.next());
        this.assertNameEquals("foobar2", this.navigator.getName());
    }

    public void testFork3() throws Exception {
        StaxNavigator<N> nav = this.navigator("<foo1><bar1><foo2/></bar1></foo1>");
        AbstractBrowseTestCase.assertTrue((boolean)nav.find(this.createName("bar1")));
        StaxNavigator bar1 = nav.fork(Axis.FOLLOWING_SIBLING);
        this.assertNameEquals("bar1", bar1.getName());
        this.assertNameEquals("bar1", nav.getName());
    }

    public void testFork4() throws Exception {
        StaxNavigator<N> nav = this.navigator("<foo1><bar1><foo2/></bar1></foo1>");
        AbstractBrowseTestCase.assertTrue((boolean)nav.find(this.createName("bar1")));
        StaxNavigator bar1 = nav.fork(Axis.FOLLOWING_SIBLING);
        this.assertNameEquals("bar1", bar1.getName());
        this.assertNameEquals("bar1", nav.getName());
    }

    public void testFork5() throws Exception {
        StaxNavigator<N> nav = this.navigator("<foo1><bar1><foo2/></bar1></foo1>");
        nav.find(this.createName("bar1"));
        Iterator bar1Nav = nav.fork(this.createName("bar1")).iterator();
        AbstractBrowseTestCase.assertTrue((boolean)bar1Nav.hasNext());
        StaxNavigator bar1 = (StaxNavigator)bar1Nav.next();
        this.assertNameEquals("bar1", bar1.getName());
        this.assertNameEquals("foo2", bar1.next());
        AbstractBrowseTestCase.assertEquals(null, (Object)bar1.next());
        Iterator foo2Nav = nav.fork(this.createName("foo2")).iterator();
        AbstractBrowseTestCase.assertFalse((boolean)foo2Nav.hasNext());
    }

    public void testNamedFork1() throws Exception {
        StaxNavigator<N> nav = this.navigator("<foo1><bar1><foo2/></bar1><bar1/><bar2/><bar1><bar3/></bar1><foo3/></foo1>");
        AbstractBrowseTestCase.assertTrue((boolean)nav.find(this.createName("bar1")));
        Iterable iterable = nav.fork(this.createName("bar1"));
        Iterator iterator = iterable.iterator();
        AbstractBrowseTestCase.assertTrue((boolean)iterator.hasNext());
        StaxNavigator n1 = (StaxNavigator)iterator.next();
        this.assertNameEquals("bar1", n1.getName());
        this.assertNameEquals("foo2", n1.next());
        AbstractBrowseTestCase.assertNull((Object)n1.next());
        AbstractBrowseTestCase.assertTrue((boolean)iterator.hasNext());
        StaxNavigator n2 = (StaxNavigator)iterator.next();
        this.assertNameEquals("bar1", n2.getName());
        AbstractBrowseTestCase.assertNull((Object)n2.next());
        AbstractBrowseTestCase.assertTrue((boolean)iterator.hasNext());
        StaxNavigator n3 = (StaxNavigator)iterator.next();
        this.assertNameEquals("bar1", n3.getName());
        this.assertNameEquals("bar3", n3.next());
        AbstractBrowseTestCase.assertNull((Object)n3.next());
        AbstractBrowseTestCase.assertFalse((boolean)iterator.hasNext());
        this.assertNameEquals("bar1", nav.getName());
        this.assertNameEquals("bar3", nav.next());
        this.assertNameEquals("foo3", nav.next());
        AbstractBrowseTestCase.assertNull((Object)nav.next());
    }

    public void testNamedFork2() throws Exception {
        StaxNavigator<N> nav = this.navigator("<foo1><bar1/><bar2/></foo1>");
        AbstractBrowseTestCase.assertTrue((boolean)nav.find(this.createName("bar1")));
        Iterator i = nav.fork(this.createName("bar3")).iterator();
        AbstractBrowseTestCase.assertFalse((boolean)i.hasNext());
        this.assertNameEquals("bar1", nav.getName());
    }
}

