/*
 * Decompiled with CFR 0.152.
 */
package org.staxnav;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.staxnav.Naming;
import org.staxnav.StaxNavigator;
import org.staxnav.StaxNavigatorTestCase;
import org.staxnav.ValueType;

public class EncodedNamingTestCase
extends StaxNavigatorTestCase {
    private StaxNavigator<EncodedElement> navigator;

    protected void setUp() throws Exception {
        this.navigator = this.navigator(new EncodedNaming(), "encoded.xml");
    }

    public void testNoSuchName() {
        EncodedNamingTestCase.assertTrue((boolean)this.navigator.next((Object)EncodedElement.BOOK_ELEMENT));
        EncodedNamingTestCase.assertEquals((Object)EncodedElement.BOOK_ELEMENT, (Object)this.navigator.sibling());
        EncodedNamingTestCase.assertEquals((Object)EncodedElement.BOOK_ELEMENT, (Object)this.navigator.sibling());
        EncodedNamingTestCase.assertEquals((Object)EncodedElement.NOT_FOUND, (Object)this.navigator.next());
        EncodedNamingTestCase.assertEquals((String)"nwonknu", (String)this.navigator.getLocalName());
    }

    public void testValueType() {
        ValueType<String> decoderValueType = new ValueType<String>(){

            protected String parse(String s) throws Exception {
                return EncodedNamingTestCase.decode(s);
            }
        };
        EncodedNamingTestCase.assertTrue((boolean)this.navigator.find((Object)EncodedElement.TITLE_ELEMENT));
        EncodedNamingTestCase.assertEquals((String)"Title A", (String)((String)this.navigator.parseContent((ValueType)decoderValueType)));
        EncodedNamingTestCase.assertEquals((Object)EncodedElement.AUTHOR_ELEMENT, (Object)this.navigator.next());
        EncodedNamingTestCase.assertEquals((String)"Author A", (String)((String)this.navigator.parseContent((ValueType)decoderValueType)));
        EncodedNamingTestCase.assertTrue((boolean)this.navigator.find((Object)EncodedElement.TITLE_ELEMENT));
        EncodedNamingTestCase.assertEquals((String)"Title B", (String)((String)this.navigator.parseContent((ValueType)decoderValueType)));
        EncodedNamingTestCase.assertEquals((Object)EncodedElement.AUTHOR_ELEMENT, (Object)this.navigator.next());
        EncodedNamingTestCase.assertEquals((String)"Author B", (String)((String)this.navigator.parseContent((ValueType)decoderValueType)));
        EncodedNamingTestCase.assertTrue((boolean)this.navigator.find((Object)EncodedElement.TITLE_ELEMENT));
        EncodedNamingTestCase.assertEquals((String)"Title C", (String)((String)this.navigator.parseContent((ValueType)decoderValueType)));
        EncodedNamingTestCase.assertEquals((Object)EncodedElement.AUTHOR_ELEMENT, (Object)this.navigator.next());
        EncodedNamingTestCase.assertEquals((String)"Author C", (String)((String)this.navigator.parseContent((ValueType)decoderValueType)));
    }

    public void testForkMechanics() {
        EncodedNamingTestCase.assertEquals((Object)EncodedElement.BOOKS_ELEMENT, (Object)this.navigator.getName());
        EncodedNamingTestCase.assertEquals((Object)EncodedElement.BOOK_ELEMENT, (Object)this.navigator.next());
        int bookCount = 0;
        for (StaxNavigator fork : this.navigator.fork((Object)EncodedElement.BOOK_ELEMENT)) {
            ++bookCount;
            int titleCount = 0;
            int authorCount = 0;
            int relatedBookCount = 0;
            int relatedBookBookCount = 0;
            int notFoundCount = 0;
            EncodedElement element = (EncodedElement)fork.next();
            while (element != null) {
                if (element.equals(EncodedElement.TITLE_ELEMENT)) {
                    ++titleCount;
                } else if (element.equals(EncodedElement.AUTHOR_ELEMENT)) {
                    ++authorCount;
                } else if (element.equals(EncodedElement.RELATED_ELEMENT)) {
                    ++relatedBookCount;
                } else if (element.equals(EncodedElement.BOOK_ELEMENT)) {
                    ++relatedBookBookCount;
                } else if (element.equals(EncodedElement.NOT_FOUND)) {
                    ++notFoundCount;
                }
                element = (EncodedElement)fork.next();
            }
            EncodedNamingTestCase.assertEquals((int)1, (int)titleCount);
            EncodedNamingTestCase.assertEquals((int)1, (int)authorCount);
            EncodedNamingTestCase.assertEquals((int)1, (int)relatedBookCount);
            EncodedNamingTestCase.assertEquals((int)2, (int)relatedBookBookCount);
            EncodedNamingTestCase.assertEquals((int)1, (int)notFoundCount);
        }
        EncodedNamingTestCase.assertEquals((int)3, (int)bookCount);
    }

    private static String decode(String encoded) {
        return new StringBuilder(encoded).reverse().toString();
    }

    private static String encode(String decoded) {
        return new StringBuilder(decoded).reverse().toString();
    }

    static /* synthetic */ String access$1000(String x0) {
        return EncodedNamingTestCase.encode(x0);
    }

    private static class EncodedElement {
        private String encoded;
        private String decoded;
        private static final EncodedElement BOOKS_ELEMENT = new EncodedElement(EncodedNamingTestCase.access$1000("books"));
        private static final EncodedElement BOOK_ELEMENT = new EncodedElement(EncodedNamingTestCase.access$1000("book"));
        private static final EncodedElement TITLE_ELEMENT = new EncodedElement(EncodedNamingTestCase.access$1000("title"));
        private static final EncodedElement AUTHOR_ELEMENT = new EncodedElement(EncodedNamingTestCase.access$1000("author"));
        private static final EncodedElement RELATED_ELEMENT = new EncodedElement(EncodedNamingTestCase.access$1000("related-books"));
        private static final EncodedElement NOT_FOUND = new EncodedElement(EncodedNamingTestCase.access$1000("not-found"));
        private static final Map<String, EncodedElement> MAP;

        EncodedElement(String localName) {
            this.encoded = localName;
            this.decoded = EncodedNamingTestCase.decode(localName);
        }

        public int hashCode() {
            return this.decoded.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof EncodedElement) {
                return this.decoded.equals(((EncodedElement)obj).decoded);
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.decoded;
        }

        static {
            HashMap<String, EncodedElement> map = new HashMap<String, EncodedElement>();
            map.put(EncodedElement.BOOKS_ELEMENT.encoded, BOOKS_ELEMENT);
            map.put(EncodedElement.BOOK_ELEMENT.encoded, BOOK_ELEMENT);
            map.put(EncodedElement.TITLE_ELEMENT.encoded, TITLE_ELEMENT);
            map.put(EncodedElement.AUTHOR_ELEMENT.encoded, AUTHOR_ELEMENT);
            map.put(EncodedElement.RELATED_ELEMENT.encoded, RELATED_ELEMENT);
            MAP = map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EncodedNaming
    extends Naming<EncodedElement> {
        private EncodedNaming() {
        }

        public String getLocalPart(EncodedElement name) {
            return name.encoded;
        }

        public String getURI(EncodedElement name) {
            return null;
        }

        public String getPrefix(EncodedElement name) {
            return null;
        }

        public EncodedElement getName(QName name) {
            return name == null ? null : this.getName(name.getNamespaceURI(), name.getPrefix(), name.getLocalPart());
        }

        public EncodedElement getName(String uri, String prefix, String localPart) {
            EncodedElement element = (EncodedElement)EncodedElement.MAP.get(localPart);
            return element != null ? element : EncodedElement.NOT_FOUND;
        }
    }
}

