/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientTioConfig;
import org.tio.core.ChannelContext;
import org.tio.utils.SystemTimer;
import org.tio.utils.thread.pool.DefaultThreadFactory;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class ReconnConf {
    private static Logger log = LoggerFactory.getLogger(ReconnConf.class);
    private long interval = 5000L;
    private int retryCount = 0;
    LinkedBlockingQueue<ChannelContext> queue = new LinkedBlockingQueue();
    private volatile SynThreadPoolExecutor threadPoolExecutor = null;

    public static ReconnConf getReconnConf(ClientChannelContext clientChannelContext) {
        ClientTioConfig clientTioConfig = (ClientTioConfig)clientChannelContext.tioConfig;
        ReconnConf reconnConf = clientTioConfig.getReconnConf();
        return reconnConf;
    }

    public static ReconnConf getReconnConf(ChannelContext channelContext) {
        return ReconnConf.getReconnConf((ClientChannelContext)channelContext);
    }

    public static boolean isNeedReconn(ClientChannelContext clientChannelContext, boolean putIfNeedConn) {
        if (clientChannelContext == null) {
            return false;
        }
        ReconnConf reconnConf = ReconnConf.getReconnConf(clientChannelContext);
        if (reconnConf == null) {
            return false;
        }
        if (reconnConf.getInterval() > 0L) {
            if (reconnConf.getRetryCount() <= 0 || reconnConf.getRetryCount() > clientChannelContext.getReconnCount().get()) {
                if (putIfNeedConn) {
                    ClientTioConfig clientTioConfig = (ClientTioConfig)clientChannelContext.tioConfig;
                    clientTioConfig.closeds.add((Object)clientChannelContext);
                    clientChannelContext.stat.timeInReconnQueue = SystemTimer.currTime;
                    reconnConf.getQueue().add(clientChannelContext);
                }
                return true;
            }
            log.info("\u4e0d\u9700\u8981\u91cd\u8fde{}", (Object)clientChannelContext);
            return false;
        }
        return false;
    }

    public static boolean put(ClientChannelContext clientChannelContext) {
        if (clientChannelContext == null) {
            return false;
        }
        return ReconnConf.isNeedReconn(clientChannelContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReconnConf() {
        if (this.threadPoolExecutor != null) return;
        Class<ReconnConf> clazz = ReconnConf.class;
        synchronized (ReconnConf.class) {
            if (this.threadPoolExecutor != null) return;
            LinkedBlockingQueue tioQueue = new LinkedBlockingQueue();
            String tioThreadName = "tio-client-reconn";
            DefaultThreadFactory defaultThreadFactory = DefaultThreadFactory.getInstance((String)tioThreadName, (Integer)10);
            this.threadPoolExecutor = new SynThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 60L, tioQueue, (ThreadFactory)defaultThreadFactory, tioThreadName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public ReconnConf(long interval) {
        this();
        this.setInterval(interval);
    }

    public ReconnConf(long interval, int retryCount) {
        this();
        this.interval = interval;
        this.retryCount = retryCount;
    }

    public long getInterval() {
        return this.interval;
    }

    public LinkedBlockingQueue<ChannelContext> getQueue() {
        return this.queue;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public SynThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }
}

