/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.metadata;

import java.nio.ByteBuffer;
import java.nio.channels.NonWritableChannelException;
import org.tensorflow.lite.support.metadata.Preconditions;
import org.tensorflow.lite.support.metadata.SeekableByteChannelCompat;

final class ByteBufferChannel
implements SeekableByteChannelCompat {
    private final ByteBuffer buffer;

    public ByteBufferChannel(ByteBuffer buffer) {
        Preconditions.checkNotNull(buffer, "The ByteBuffer cannot be null.");
        this.buffer = buffer;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public long position() {
        return this.buffer.position();
    }

    @Override
    public synchronized ByteBufferChannel position(long newPosition) {
        Preconditions.checkArgument(newPosition >= 0L && newPosition <= Integer.MAX_VALUE, "The new position should be non-negative and be less than Integer.MAX_VALUE.");
        this.buffer.position((int)newPosition);
        return this;
    }

    @Override
    public synchronized int read(ByteBuffer dst) {
        if (this.buffer.remaining() == 0) {
            return -1;
        }
        int count = Math.min(dst.remaining(), this.buffer.remaining());
        if (count > 0) {
            ByteBuffer tempBuffer = this.buffer.slice();
            tempBuffer.order(this.buffer.order()).limit(count);
            dst.put(tempBuffer);
            this.buffer.position(this.buffer.position() + count);
        }
        return count;
    }

    @Override
    public long size() {
        return this.buffer.limit();
    }

    @Override
    public synchronized ByteBufferChannel truncate(long size) {
        Preconditions.checkArgument(size >= 0L && size <= Integer.MAX_VALUE, "The new size should be non-negative and be less than Integer.MAX_VALUE.");
        if (size < (long)this.buffer.limit()) {
            this.buffer.limit((int)size);
            if ((long)this.buffer.position() > size) {
                this.buffer.position((int)size);
            }
        }
        return this;
    }

    @Override
    public synchronized int write(ByteBuffer src) {
        if (this.buffer.isReadOnly()) {
            throw new NonWritableChannelException();
        }
        int count = Math.min(src.remaining(), this.buffer.remaining());
        if (count > 0) {
            ByteBuffer tempBuffer = src.slice();
            tempBuffer.order(this.buffer.order()).limit(count);
            this.buffer.put(tempBuffer);
        }
        return count;
    }
}

