/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.IntSet;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;

class MouseState {
    static final int WHEEL_NONE = 0;
    static final int WHEEL_UP = 1;
    static final int WHEEL_DOWN = -1;
    private int x;
    private int y;
    private int wheel;
    private MonocleWindow window;
    private IntSet buttonsPressed = new IntSet();

    MouseState() {
    }

    int getX() {
        return this.x;
    }

    void setX(int x) {
        this.x = x;
    }

    int getY() {
        return this.y;
    }

    void setY(int y) {
        this.y = y;
    }

    int getWheel() {
        return this.wheel;
    }

    void setWheel(int wheel) {
        this.wheel = wheel;
    }

    void pressButton(int button) {
        this.buttonsPressed.addInt(button);
    }

    void releaseButton(int button) {
        this.buttonsPressed.removeInt(button);
    }

    MonocleWindow getWindow(boolean recalculateCache) {
        if (this.window == null || recalculateCache) {
            this.window = MonocleWindowManager.getInstance().getWindowForLocation(this.x, this.y);
        }
        return this.window;
    }

    int getButton() {
        return this.buttonsPressed.isEmpty() ? 211 : this.buttonsPressed.get(0);
    }

    int getModifiers() {
        int modifiers = 0;
        block5: for (int i = 0; i < this.buttonsPressed.size(); ++i) {
            switch (this.buttonsPressed.get(i)) {
                case 212: {
                    modifiers |= 0x20;
                    continue block5;
                }
                case 214: {
                    modifiers |= 0x80;
                    continue block5;
                }
                case 213: {
                    modifiers |= 0x40;
                }
            }
        }
        return modifiers;
    }

    void copyTo(MouseState target) {
        target.x = this.x;
        target.y = this.y;
        target.wheel = this.wheel;
        this.buttonsPressed.copyTo(target.buttonsPressed);
        target.window = this.window;
    }

    IntSet getButtonsPressed() {
        return this.buttonsPressed;
    }

    public String toString() {
        return "MouseState[x=" + this.x + ",y=" + this.y + ",wheel=" + this.wheel + ",buttonsPressed=" + this.buttonsPressed + "]";
    }

    boolean canBeFoldedWith(MouseState ms) {
        return ms.buttonsPressed.equals(this.buttonsPressed) && ms.wheel == this.wheel;
    }
}

