/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.api;

import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javafx.geometry.Bounds;
import javafx.geometry.HorizontalDirection;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VerticalDirection;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.MouseButton;
import javafx.stage.Window;
import org.hamcrest.Matcher;
import org.testfx.robot.Motion;
import org.testfx.service.query.BoundsQuery;
import org.testfx.service.query.NodeQuery;
import org.testfx.service.query.PointQuery;
import org.testfx.service.support.Capture;

public interface FxRobotInterface {
    public Window targetWindow();

    public FxRobotInterface targetWindow(Window var1);

    public FxRobotInterface targetWindow(Predicate<Window> var1);

    public FxRobotInterface targetWindow(int var1);

    public FxRobotInterface targetWindow(String var1);

    public FxRobotInterface targetWindow(Pattern var1);

    public FxRobotInterface targetWindow(Scene var1);

    public FxRobotInterface targetWindow(Node var1);

    public List<Window> listWindows();

    public List<Window> listTargetWindows();

    public Window window(Predicate<Window> var1);

    public Window window(int var1);

    public Window window(String var1);

    public Window window(Pattern var1);

    public Window window(Scene var1);

    public Window window(Node var1);

    public NodeQuery fromAll();

    public NodeQuery from(Node ... var1);

    public NodeQuery from(Collection<Node> var1);

    public Node rootNode(Window var1);

    public Node rootNode(Scene var1);

    public Node rootNode(Node var1);

    public NodeQuery lookup(String var1);

    public <T extends Node> NodeQuery lookup(Matcher<T> var1);

    public <T extends Node> NodeQuery lookup(Predicate<T> var1);

    public NodeQuery from(NodeQuery var1);

    public BoundsQuery bounds(double var1, double var3, double var5, double var7);

    public BoundsQuery bounds(Point2D var1);

    public BoundsQuery bounds(Bounds var1);

    public BoundsQuery bounds(Node var1);

    public BoundsQuery bounds(Scene var1);

    public BoundsQuery bounds(Window var1);

    public BoundsQuery bounds(String var1);

    public <T extends Node> BoundsQuery bounds(Matcher<T> var1);

    public <T extends Node> BoundsQuery bounds(Predicate<T> var1);

    public FxRobotInterface targetPos(Pos var1);

    public PointQuery point(double var1, double var3);

    public PointQuery point(Point2D var1);

    public PointQuery point(Bounds var1);

    public PointQuery point(Node var1);

    public PointQuery point(Scene var1);

    public PointQuery point(Window var1);

    public PointQuery point(String var1);

    public <T extends Node> PointQuery point(Matcher<T> var1);

    public <T extends Node> PointQuery point(Predicate<T> var1);

    public PointQuery offset(Point2D var1, double var2, double var4);

    default public PointQuery offset(Point2D point, Point2D offset) {
        return this.offset(point, offset.getX(), offset.getY());
    }

    public PointQuery offset(Bounds var1, double var2, double var4);

    default public PointQuery offset(Bounds bounds, Point2D offset) {
        return this.offset(bounds, offset.getX(), offset.getY());
    }

    public PointQuery offset(Node var1, double var2, double var4);

    default public PointQuery offset(Node node, Point2D offset) {
        return this.offset(node, offset.getX(), offset.getY());
    }

    public PointQuery offset(Node var1, Pos var2, double var3, double var5);

    default public PointQuery offset(Node node, Pos offsetReferencePos, Point2D offset) {
        return this.offset(node, offsetReferencePos, offset.getX(), offset.getY());
    }

    public PointQuery offset(Scene var1, double var2, double var4);

    default public PointQuery offset(Scene scene, Point2D offset) {
        return this.offset(scene, offset.getX(), offset.getY());
    }

    public PointQuery offset(Window var1, double var2, double var4);

    default public PointQuery offset(Window window, Point2D offset) {
        return this.offset(window, offset.getX(), offset.getY());
    }

    public PointQuery offset(String var1, double var2, double var4);

    default public PointQuery offset(String query, Point2D offset) {
        return this.offset(query, offset.getX(), offset.getY());
    }

    public <T extends Node> PointQuery offset(Matcher<T> var1, double var2, double var4);

    default public <T extends Node> PointQuery offset(Matcher<T> matcher, Point2D offset) {
        return this.offset(matcher, offset.getX(), offset.getY());
    }

    public <T extends Node> PointQuery offset(Predicate<T> var1, double var2, double var4);

    default public <T extends Node> PointQuery offset(Predicate<T> predicate, Point2D offset) {
        return this.offset(predicate, offset.getX(), offset.getY());
    }

    public Capture capture(Rectangle2D var1);

    public Capture capture(Bounds var1);

    public Capture capture(Node var1);

    public Capture capture(Image var1);

    public Capture capture(Path var1);

    public Capture capture(URL var1);

    public FxRobotInterface interact(Runnable var1);

    public <T> FxRobotInterface interact(Callable<T> var1);

    public FxRobotInterface interactNoWait(Runnable var1);

    public <T> FxRobotInterface interactNoWait(Callable<T> var1);

    public FxRobotInterface interrupt();

    public FxRobotInterface interrupt(int var1);

    public FxRobotInterface sleep(long var1);

    public FxRobotInterface sleep(long var1, TimeUnit var3);

    public FxRobotInterface clickOn(MouseButton ... var1);

    default public FxRobotInterface clickOn(PointQuery pointQuery, MouseButton ... buttons) {
        return this.clickOn(pointQuery, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface clickOn(PointQuery var1, Motion var2, MouseButton ... var3);

    public FxRobotInterface doubleClickOn(MouseButton ... var1);

    default public FxRobotInterface doubleClickOn(PointQuery pointQuery, MouseButton ... buttons) {
        return this.doubleClickOn(pointQuery, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface doubleClickOn(PointQuery var1, Motion var2, MouseButton ... var3);

    default public FxRobotInterface clickOn(double x, double y, MouseButton ... buttons) {
        return this.clickOn(x, y, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface clickOn(double var1, double var3, Motion var5, MouseButton ... var6);

    default public FxRobotInterface clickOn(Point2D point, MouseButton ... buttons) {
        return this.clickOn(point, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface clickOn(Point2D var1, Motion var2, MouseButton ... var3);

    default public FxRobotInterface clickOn(Bounds bounds, MouseButton ... buttons) {
        return this.clickOn(bounds, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface clickOn(Bounds var1, Motion var2, MouseButton ... var3);

    default public FxRobotInterface clickOn(Node node, MouseButton ... buttons) {
        return this.clickOn(node, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface clickOn(Node var1, Motion var2, MouseButton ... var3);

    default public FxRobotInterface clickOn(Scene scene, MouseButton ... buttons) {
        return this.clickOn(scene, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface clickOn(Scene var1, Motion var2, MouseButton ... var3);

    default public FxRobotInterface clickOn(Window window, MouseButton ... buttons) {
        return this.clickOn(window, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface clickOn(Window var1, Motion var2, MouseButton ... var3);

    default public FxRobotInterface clickOn(String query, MouseButton ... buttons) {
        return this.clickOn(query, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface clickOn(String var1, Motion var2, MouseButton ... var3);

    default public <T extends Node> FxRobotInterface clickOn(Matcher<T> matcher, MouseButton ... buttons) {
        return this.clickOn(matcher, Motion.DEFAULT, buttons);
    }

    public <T extends Node> FxRobotInterface clickOn(Matcher<T> var1, Motion var2, MouseButton ... var3);

    default public <T extends Node> FxRobotInterface clickOn(Predicate<T> predicate, MouseButton ... buttons) {
        return this.clickOn(predicate, Motion.DEFAULT, buttons);
    }

    public <T extends Node> FxRobotInterface clickOn(Predicate<T> var1, Motion var2, MouseButton ... var3);

    public FxRobotInterface rightClickOn();

    default public FxRobotInterface rightClickOn(PointQuery pointQuery) {
        return this.rightClickOn(pointQuery, Motion.DEFAULT);
    }

    public FxRobotInterface rightClickOn(PointQuery var1, Motion var2);

    default public FxRobotInterface rightClickOn(double x, double y) {
        return this.rightClickOn(x, y, Motion.DEFAULT);
    }

    public FxRobotInterface rightClickOn(double var1, double var3, Motion var5);

    default public FxRobotInterface rightClickOn(Point2D point) {
        return this.rightClickOn(point, Motion.DEFAULT);
    }

    public FxRobotInterface rightClickOn(Point2D var1, Motion var2);

    default public FxRobotInterface rightClickOn(Bounds bounds) {
        return this.rightClickOn(bounds, Motion.DEFAULT);
    }

    public FxRobotInterface rightClickOn(Bounds var1, Motion var2);

    default public FxRobotInterface rightClickOn(Node node) {
        return this.rightClickOn(node, Motion.DEFAULT);
    }

    public FxRobotInterface rightClickOn(Node var1, Motion var2);

    default public FxRobotInterface rightClickOn(Scene scene) {
        return this.rightClickOn(scene, Motion.DEFAULT);
    }

    public FxRobotInterface rightClickOn(Scene var1, Motion var2);

    default public FxRobotInterface rightClickOn(Window window) {
        return this.rightClickOn(window, Motion.DEFAULT);
    }

    public FxRobotInterface rightClickOn(Window var1, Motion var2);

    default public FxRobotInterface rightClickOn(String query) {
        return this.rightClickOn(query, Motion.DEFAULT);
    }

    public FxRobotInterface rightClickOn(String var1, Motion var2);

    default public <T extends Node> FxRobotInterface rightClickOn(Matcher<T> matcher) {
        return this.rightClickOn(matcher, Motion.DEFAULT);
    }

    public <T extends Node> FxRobotInterface rightClickOn(Matcher<T> var1, Motion var2);

    default public <T extends Node> FxRobotInterface rightClickOn(Predicate<T> predicate) {
        return this.rightClickOn(predicate, Motion.DEFAULT);
    }

    public <T extends Node> FxRobotInterface rightClickOn(Predicate<T> var1, Motion var2);

    default public FxRobotInterface doubleClickOn(double x, double y, MouseButton ... buttons) {
        return this.doubleClickOn(x, y, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface doubleClickOn(double var1, double var3, Motion var5, MouseButton ... var6);

    default public FxRobotInterface doubleClickOn(Point2D point, MouseButton ... buttons) {
        return this.doubleClickOn(point, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface doubleClickOn(Point2D var1, Motion var2, MouseButton ... var3);

    default public FxRobotInterface doubleClickOn(Bounds bounds, MouseButton ... buttons) {
        return this.doubleClickOn(bounds, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface doubleClickOn(Bounds var1, Motion var2, MouseButton ... var3);

    default public FxRobotInterface doubleClickOn(Node node, MouseButton ... buttons) {
        return this.doubleClickOn(node, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface doubleClickOn(Node var1, Motion var2, MouseButton ... var3);

    default public FxRobotInterface doubleClickOn(Scene scene, MouseButton ... buttons) {
        return this.doubleClickOn(scene, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface doubleClickOn(Scene var1, Motion var2, MouseButton ... var3);

    default public FxRobotInterface doubleClickOn(Window window, MouseButton ... buttons) {
        return this.doubleClickOn(window, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface doubleClickOn(Window var1, Motion var2, MouseButton ... var3);

    default public FxRobotInterface doubleClickOn(String query, MouseButton ... buttons) {
        return this.doubleClickOn(query, Motion.DEFAULT, buttons);
    }

    public FxRobotInterface doubleClickOn(String var1, Motion var2, MouseButton ... var3);

    default public <T extends Node> FxRobotInterface doubleClickOn(Matcher<T> matcher, MouseButton ... buttons) {
        return this.doubleClickOn(matcher, Motion.DEFAULT, buttons);
    }

    public <T extends Node> FxRobotInterface doubleClickOn(Matcher<T> var1, Motion var2, MouseButton ... var3);

    default public <T extends Node> FxRobotInterface doubleClickOn(Predicate<T> predicate, MouseButton ... buttons) {
        return this.doubleClickOn(predicate, Motion.DEFAULT, buttons);
    }

    public <T extends Node> FxRobotInterface doubleClickOn(Predicate<T> var1, Motion var2, MouseButton ... var3);

    public FxRobotInterface drag(MouseButton ... var1);

    public FxRobotInterface drag(PointQuery var1, MouseButton ... var2);

    public FxRobotInterface drop();

    public FxRobotInterface dropTo(PointQuery var1);

    public FxRobotInterface dropBy(double var1, double var3);

    public FxRobotInterface drag(double var1, double var3, MouseButton ... var5);

    public FxRobotInterface drag(Point2D var1, MouseButton ... var2);

    public FxRobotInterface drag(Bounds var1, MouseButton ... var2);

    public FxRobotInterface drag(Node var1, MouseButton ... var2);

    public FxRobotInterface drag(Scene var1, MouseButton ... var2);

    public FxRobotInterface drag(Window var1, MouseButton ... var2);

    public FxRobotInterface drag(String var1, MouseButton ... var2);

    public <T extends Node> FxRobotInterface drag(Matcher<T> var1, MouseButton ... var2);

    public <T extends Node> FxRobotInterface drag(Predicate<T> var1, MouseButton ... var2);

    public FxRobotInterface dropTo(double var1, double var3);

    public FxRobotInterface dropTo(Point2D var1);

    public FxRobotInterface dropTo(Bounds var1);

    public FxRobotInterface dropTo(Node var1);

    public FxRobotInterface dropTo(Scene var1);

    public FxRobotInterface dropTo(Window var1);

    public FxRobotInterface dropTo(String var1);

    public <T extends Node> FxRobotInterface dropTo(Matcher<T> var1);

    public <T extends Node> FxRobotInterface dropTo(Predicate<T> var1);

    public FxRobotInterface press(KeyCode ... var1);

    public FxRobotInterface release(KeyCode ... var1);

    public FxRobotInterface press(MouseButton ... var1);

    public FxRobotInterface release(MouseButton ... var1);

    default public FxRobotInterface moveTo(PointQuery pointQuery) {
        return this.moveTo(pointQuery, Motion.DEFAULT);
    }

    public FxRobotInterface moveTo(PointQuery var1, Motion var2);

    default public FxRobotInterface moveBy(double x, double y) {
        return this.moveBy(x, y, Motion.DEFAULT);
    }

    public FxRobotInterface moveBy(double var1, double var3, Motion var5);

    default public FxRobotInterface moveTo(double x, double y) {
        return this.moveTo(x, y, Motion.DEFAULT);
    }

    public FxRobotInterface moveTo(double var1, double var3, Motion var5);

    default public FxRobotInterface moveTo(Point2D point) {
        return this.moveTo(point, Motion.DEFAULT);
    }

    public FxRobotInterface moveTo(Point2D var1, Motion var2);

    default public FxRobotInterface moveTo(Bounds bounds) {
        return this.moveTo(bounds, Motion.DEFAULT);
    }

    public FxRobotInterface moveTo(Bounds var1, Motion var2);

    default public FxRobotInterface moveTo(Node node) {
        return this.moveTo(node, Motion.DEFAULT);
    }

    default public FxRobotInterface moveTo(Node node, Motion motion) {
        return this.moveTo(node, Pos.CENTER, Point2D.ZERO, motion);
    }

    default public FxRobotInterface moveTo(Node node, Point2D offset) {
        return this.moveTo(node, Pos.CENTER, offset, Motion.DEFAULT);
    }

    public FxRobotInterface moveTo(Node var1, Pos var2, Point2D var3, Motion var4);

    default public FxRobotInterface moveTo(Scene scene) {
        return this.moveTo(scene, Motion.DEFAULT);
    }

    public FxRobotInterface moveTo(Scene var1, Motion var2);

    default public FxRobotInterface moveTo(Window window) {
        return this.moveTo(window, Motion.DEFAULT);
    }

    public FxRobotInterface moveTo(Window var1, Motion var2);

    default public FxRobotInterface moveTo(String query) {
        return this.moveTo(query, Motion.DEFAULT);
    }

    public FxRobotInterface moveTo(String var1, Motion var2);

    default public <T extends Node> FxRobotInterface moveTo(Matcher<T> matcher) {
        return this.moveTo(matcher, Motion.DEFAULT);
    }

    public <T extends Node> FxRobotInterface moveTo(Matcher<T> var1, Motion var2);

    default public <T extends Node> FxRobotInterface moveTo(Predicate<T> predicate) {
        return this.moveTo(predicate, Motion.DEFAULT);
    }

    public <T extends Node> FxRobotInterface moveTo(Predicate<T> var1, Motion var2);

    public FxRobotInterface scroll(int var1);

    public FxRobotInterface scroll(int var1, VerticalDirection var2);

    public FxRobotInterface scroll(VerticalDirection var1);

    public FxRobotInterface scroll(int var1, HorizontalDirection var2);

    public FxRobotInterface scroll(HorizontalDirection var1);

    public FxRobotInterface push(KeyCode ... var1);

    public FxRobotInterface push(KeyCodeCombination var1);

    public FxRobotInterface type(KeyCode ... var1);

    public FxRobotInterface type(KeyCode var1, int var2);

    public FxRobotInterface eraseText(int var1);

    public FxRobotInterface write(char var1);

    public FxRobotInterface write(String var1);

    public FxRobotInterface write(String var1, int var2);
}

