/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.matcher.base;

import java.util.Objects;
import javafx.css.Styleable;
import org.hamcrest.Matcher;
import org.testfx.matcher.base.GeneralMatchers;

public class StyleableMatchers {
    private StyleableMatchers() {
    }

    public static Matcher<Styleable> hasTypeSelector(String typeSelector) {
        String descriptionText = "has type selector \"" + typeSelector + "\"";
        return GeneralMatchers.typeSafeMatcher(Styleable.class, descriptionText, styleable -> "\"" + styleable.getTypeSelector() + "\"", styleable -> Objects.equals(typeSelector, styleable.getTypeSelector()));
    }

    public static Matcher<Styleable> hasId(String id) {
        String descriptionText = "has CSS id \"" + id + "\"";
        return GeneralMatchers.typeSafeMatcher(Styleable.class, descriptionText, styleable -> "\"" + styleable.getId() + "\"", styleable -> Objects.equals(id, styleable.getId()));
    }

    public static Matcher<Styleable> hasStyle(String style) {
        String descriptionText = "has CSS style \"" + style + "\"";
        return GeneralMatchers.typeSafeMatcher(Styleable.class, descriptionText, styleable -> "\"" + styleable.getStyle() + "\"", styleable -> Objects.equals(style, styleable.getStyle()));
    }

    public static Matcher<Styleable> hasStyleableParent(Styleable styleableParent) {
        String descriptionText = "has styleable parent \"" + styleableParent + "\"";
        return GeneralMatchers.typeSafeMatcher(Styleable.class, descriptionText, styleable -> "\"" + styleable.getStyleableParent() + "\"", styleable -> Objects.equals(styleableParent, styleable.getStyleableParent()));
    }
}

