/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.support.impl;

import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import org.testfx.service.support.PixelMatcher;
import org.testfx.service.support.impl.PixelMatcherBase;
import org.testfx.util.ColorUtils;

public class PixelMatcherRgb
extends PixelMatcherBase
implements PixelMatcher {
    private final double colorBlendFactor;
    private final double minColorDistSq;

    public PixelMatcherRgb() {
        this(0.2, 0.75);
    }

    public PixelMatcherRgb(double minColorDistFactor, double colorBlendFactor) {
        this.colorBlendFactor = colorBlendFactor;
        double maxColorDistSq = ColorUtils.calculateColorDistSq(Color.BLACK, Color.WHITE);
        this.minColorDistSq = maxColorDistSq * (minColorDistFactor * minColorDistFactor);
    }

    @Override
    public boolean matchColors(Color color0, Color color1) {
        double colorDistSq = ColorUtils.calculateColorDistSq(color0, color1);
        return colorDistSq < this.minColorDistSq;
    }

    @Override
    public WritableImage createEmptyMatchImage(Image image0, Image image1) {
        return new WritableImage((int)image0.getWidth(), (int)image1.getHeight());
    }

    @Override
    public Color createMatchColor(Color color0, Color color1) {
        double gray = color0.grayscale().getRed();
        double opacity = color0.getOpacity();
        return Color.gray((double)this.blendToWhite(gray, this.colorBlendFactor), (double)opacity);
    }

    private double blendToWhite(double gray, double factor) {
        return (1.0 - factor) * gray + factor;
    }
}

