/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.util;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;
import org.testfx.internal.JavaVersionAdapter;

public final class BoundsQueryUtils {
    private BoundsQueryUtils() {
    }

    public static Bounds bounds(double minX, double minY, double width, double height) {
        return new BoundingBox(minX, minY, width, height);
    }

    public static Bounds bounds(Point2D point) {
        return BoundsQueryUtils.bounds(point.getX(), point.getY(), 0.0, 0.0);
    }

    public static Bounds bounds(Dimension2D dimension) {
        return BoundsQueryUtils.bounds(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
    }

    public static Bounds bounds(Rectangle2D region) {
        return BoundsQueryUtils.bounds(region.getMinX(), region.getMinY(), region.getWidth(), region.getHeight());
    }

    public static Bounds bounds(Scene scene) {
        return BoundsQueryUtils.bounds(scene.getX(), scene.getY(), scene.getWidth(), scene.getHeight());
    }

    public static Bounds bounds(Window window) {
        return BoundsQueryUtils.bounds(window.getX(), window.getY(), window.getWidth(), window.getHeight());
    }

    public static Bounds nodeBounds(Node node) {
        return node.getLayoutBounds();
    }

    public static Bounds nodeBoundsInLocal(Node node) {
        return node.getBoundsInLocal();
    }

    public static Bounds nodeBoundsInParent(Node node) {
        return node.getBoundsInParent();
    }

    public static Bounds nodeBoundsInScene(Node node) {
        return node.localToScene(node.getBoundsInLocal());
    }

    public static Bounds boundsOnScreen(Node node) {
        Bounds boundsInScene = BoundsQueryUtils.nodeBoundsInScene(node);
        return BoundsQueryUtils.boundsOnScreen(boundsInScene, node.getScene());
    }

    public static Bounds boundsOnScreen(Bounds boundsInScene, Scene scene) {
        Bounds sceneBoundsInWindow = BoundsQueryUtils.bounds(scene);
        Bounds windowBoundsOnScreen = BoundsQueryUtils.bounds(scene.getWindow());
        return BoundsQueryUtils.translateBounds(boundsInScene, BoundsQueryUtils.byOffset(sceneBoundsInWindow.getMinX() + windowBoundsOnScreen.getMinX(), sceneBoundsInWindow.getMinY() + windowBoundsOnScreen.getMinY()));
    }

    public static Bounds boundsOnScreen(Bounds boundsInWindow, Window window) {
        Bounds windowBoundsOnScreen = BoundsQueryUtils.bounds(window);
        return BoundsQueryUtils.translateBounds(boundsInWindow, BoundsQueryUtils.byOffset(windowBoundsOnScreen.getMinX(), windowBoundsOnScreen.getMinY()));
    }

    public static Bounds boundsOnScreen(Bounds boundsOnScreen, Rectangle2D screenRegion) {
        return BoundsQueryUtils.translateBounds(boundsOnScreen, BoundsQueryUtils.byOffset(screenRegion.getMinX(), screenRegion.getMinY()));
    }

    public static Bounds scale(Bounds bounds) {
        double scaleX = JavaVersionAdapter.getScreenScaleX();
        double scaleY = JavaVersionAdapter.getScreenScaleY();
        if (scaleX != 1.0 || scaleY != 1.0) {
            return new BoundingBox(bounds.getMinX() * scaleX, bounds.getMinY() * scaleY, bounds.getMinZ(), bounds.getWidth() * scaleX, bounds.getHeight() * scaleY, bounds.getDepth());
        }
        return bounds;
    }

    private static Bounds limitToVisibleBounds(Bounds boundsInScene, Scene scene) {
        Bounds sceneBounds = BoundsQueryUtils.makeSceneBounds(scene);
        Bounds visibleBounds = BoundsQueryUtils.intersectBounds(boundsInScene, sceneBounds);
        if (!BoundsQueryUtils.areBoundsVisible(visibleBounds)) {
            throw new RuntimeException("bounds are not visible in Scene.");
        }
        return visibleBounds;
    }

    private static Bounds makeSceneBounds(Scene scene) {
        return new BoundingBox(0.0, 0.0, scene.getWidth(), scene.getHeight());
    }

    private static Bounds intersectBounds(Bounds a, Bounds b) {
        double minX = Math.max(a.getMinX(), b.getMinX());
        double minY = Math.max(a.getMinY(), b.getMinY());
        double maxX = Math.min(a.getMaxX(), b.getMaxX());
        double maxY = Math.min(a.getMaxY(), b.getMaxY());
        double width = maxX - minX;
        double height = maxY - minY;
        return new BoundingBox(minX, minY, width, height);
    }

    private static boolean areBoundsVisible(Bounds bounds) {
        return !bounds.isEmpty();
    }

    private static Bounds translateBounds(Bounds bounds, Point2D offset) {
        return new BoundingBox(bounds.getMinX() + offset.getX(), bounds.getMinY() + offset.getY(), bounds.getWidth(), bounds.getHeight());
    }

    private static Point2D byOffset(double x, double y) {
        return new Point2D(x, y);
    }
}

