/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.util;

import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.VPos;

public final class PointQueryUtils {
    private PointQueryUtils() {
    }

    public static Point2D atPosition(Bounds bounds, Pos position) {
        return PointQueryUtils.atPositionFactors(bounds, PointQueryUtils.computePositionFactors(position));
    }

    public static Point2D atPositionFactors(Bounds bounds, Point2D positionFactors) {
        double pointX = PointQueryUtils.lerp(bounds.getMinX(), bounds.getWidth(), positionFactors.getX());
        double pointY = PointQueryUtils.lerp(bounds.getMinY(), bounds.getHeight(), positionFactors.getY());
        return new Point2D(pointX, pointY);
    }

    public static Point2D computePositionFactors(Pos position) {
        double positionX = PointQueryUtils.computePositionX(position.getHpos());
        double positionY = PointQueryUtils.computePositionY(position.getVpos());
        return new Point2D(positionX, positionY);
    }

    private static double lerp(double start, double distance, double factor) {
        return start + distance * factor;
    }

    private static double computePositionX(HPos hPos) {
        switch (hPos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return 0.5;
            }
            case RIGHT: {
                return 1.0;
            }
        }
        throw new RuntimeException("unhandled hPos: " + hPos);
    }

    private static double computePositionY(VPos vPos) {
        switch (vPos) {
            case TOP: {
                return 0.0;
            }
            case BASELINE: 
            case CENTER: {
                return 0.5;
            }
            case BOTTOM: {
                return 1.0;
            }
        }
        throw new RuntimeException("unhandled vPos: " + vPos);
    }
}

