/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity6.dialect.processor;

import org.springframework.security.core.Authentication;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.extras.springsecurity6.auth.AuthUtils;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.EscapedAttributeUtils;

public final class AuthenticationAttrProcessor
extends AbstractAttributeTagProcessor {
    public static final int ATTR_PRECEDENCE = 1300;
    public static final String ATTR_NAME = "authentication";

    public AuthenticationAttrProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, dialectPrefix, null, false, ATTR_NAME, true, 1300, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        String attrValue;
        String string = attrValue = attributeValue == null ? null : attributeValue.trim();
        if (attrValue == null || attrValue.length() == 0) {
            return;
        }
        Authentication authentication = AuthUtils.getAuthenticationObject((IExpressionContext)context);
        Object authenticationProperty = AuthUtils.getAuthenticationProperty(authentication, attrValue);
        if (authenticationProperty == null) {
            return;
        }
        String encodedAttribute = EscapedAttributeUtils.escapeAttribute((TemplateMode)this.getTemplateMode(), (String)authenticationProperty.toString());
        structureHandler.setBody((CharSequence)encodedAttribute, false);
    }
}

