/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.Level;
import org.tinylog.Supplier;
import org.tinylog.configuration.Configuration;
import org.tinylog.format.AdvancedMessageFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.kotlin.Logger;
import org.tinylog.kotlin.SupplierUtilsKt;
import org.tinylog.kotlin.TaggedLogger;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012J7\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\"\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00190\u001b\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019\u00a2\u0006\u0002\u0010\u001cJ+\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0012J?\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00122\"\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00190\u001b\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019\u00a2\u0006\u0002\u0010 J3\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00122\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010!J\u0014\u0010\"\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0010\u0010\"\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012J7\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\"\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00190\u001b\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019\u00a2\u0006\u0002\u0010\u001cJ+\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0016\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0012J?\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00122\"\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00190\u001b\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019\u00a2\u0006\u0002\u0010 J3\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00122\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010!J\u0014\u0010#\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0010\u0010#\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001J\u000e\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012J7\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\"\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00190\u001b\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019\u00a2\u0006\u0002\u0010\u001cJ+\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010#\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010#\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0016\u0010#\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0012J?\u0010#\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00122\"\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00190\u001b\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019\u00a2\u0006\u0002\u0010 J3\u0010#\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00122\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010!J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020\u0004J\u0006\u0010(\u001a\u00020\u0004J\u0006\u0010)\u001a\u00020\u0004J\u0006\u0010*\u001a\u00020\u0004J\u0006\u0010+\u001a\u00020\u0004J\u0010\u0010,\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010\u0012J#\u0010-\u001a\u00020\u000e2\u0016\u0010-\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\u001b\"\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010.J\u0014\u0010/\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0010\u0010/\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001J\u000e\u0010/\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012J7\u0010/\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\"\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00190\u001b\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019\u00a2\u0006\u0002\u0010\u001cJ+\u0010/\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010/\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010/\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0016\u0010/\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0012J?\u0010/\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00122\"\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00190\u001b\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019\u00a2\u0006\u0002\u0010 J3\u0010/\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00122\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010!J\u0014\u00100\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0010\u00100\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001J\u000e\u00100\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012J7\u00100\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\"\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00190\u001b\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019\u00a2\u0006\u0002\u0010\u001cJ+\u00100\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001dJ\u000e\u00100\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u00100\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0016\u00100\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0012J?\u00100\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00122\"\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00190\u001b\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019\u00a2\u0006\u0002\u0010 J3\u00100\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00122\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/tinylog/kotlin/Logger;", "", "()V", "MINIMUM_LEVEL_COVERS_DEBUG", "", "MINIMUM_LEVEL_COVERS_ERROR", "MINIMUM_LEVEL_COVERS_INFO", "MINIMUM_LEVEL_COVERS_TRACE", "MINIMUM_LEVEL_COVERS_WARN", "STACKTRACE_DEPTH", "", "formatter", "Lorg/tinylog/format/AdvancedMessageFormatter;", "instance", "Lorg/tinylog/kotlin/TaggedLogger;", "loggers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "provider", "Lorg/tinylog/provider/LoggingProvider;", "kotlin.jvm.PlatformType", "debug", "", "message", "Lkotlin/Function0;", "arguments", "", "(Ljava/lang/String;[Lkotlin/jvm/functions/Function0;)V", "(Ljava/lang/String;[Ljava/lang/Object;)V", "exception", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Lkotlin/jvm/functions/Function0;)V", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "error", "info", "isCoveredByMinimumLevel", "level", "Lorg/tinylog/Level;", "isDebugEnabled", "isErrorEnabled", "isInfoEnabled", "isTraceEnabled", "isWarnEnabled", "tag", "tags", "([Ljava/lang/String;)Lorg/tinylog/kotlin/TaggedLogger;", "trace", "warn", "tinylog-api-kotlin"})
public final class Logger {
    private static final int STACKTRACE_DEPTH = 2;
    private static final AdvancedMessageFormatter formatter;
    private static final LoggingProvider provider;
    private static final boolean MINIMUM_LEVEL_COVERS_TRACE;
    private static final boolean MINIMUM_LEVEL_COVERS_DEBUG;
    private static final boolean MINIMUM_LEVEL_COVERS_INFO;
    private static final boolean MINIMUM_LEVEL_COVERS_WARN;
    private static final boolean MINIMUM_LEVEL_COVERS_ERROR;
    private static final TaggedLogger instance;
    private static final ConcurrentHashMap<Set<String>, TaggedLogger> loggers;
    @NotNull
    public static final Logger INSTANCE;

    @NotNull
    public final TaggedLogger tag(@Nullable String tag) {
        CharSequence charSequence;
        return tag == null || (charSequence = (CharSequence)tag).length() == 0 ? instance : this.tags(tag);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TaggedLogger tags(String ... tags2) {
        TaggedLogger taggedLogger;
        Intrinsics.checkParameterIsNotNull((Object)tags2, (String)"tags");
        String[] stringArray = tags2;
        if (stringArray.length == 0) {
            taggedLogger = instance;
        } else {
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = tags2;
            boolean $i$f$map = false;
            String[] stringArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var8_8 = $this$mapTo$iv$iv;
            int n = ((void)var8_8).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var12_12 = item$iv$iv = var8_8[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                CharSequence charSequence = (CharSequence)it;
                Object e = charSequence == null || charSequence.length() == 0 ? null : it;
                collection.add(e);
            }
            Set tagsSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            TaggedLogger taggedLogger2 = loggers.computeIfAbsent(tagsSet, tags.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)taggedLogger2, (String)"loggers.computeIfAbsent(\u2026Set) { TaggedLogger(it) }");
            taggedLogger = taggedLogger2;
        }
        return taggedLogger;
    }

    public final boolean isTraceEnabled() {
        return MINIMUM_LEVEL_COVERS_TRACE && provider.isEnabled(2, null, Level.TRACE);
    }

    public final void trace(@Nullable Object message) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, null, message, new Object[0]);
        }
    }

    public final void trace(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, null, (Object)message, new Object[0]);
        }
    }

    public final void trace(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
        }
    }

    public final void trace(@NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void trace(@NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
            provider.log(2, null, Level.TRACE, null, (MessageFormatter)formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
        }
    }

    public final void trace(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, null, null, new Object[0]);
        }
    }

    public final void trace(@NotNull Throwable exception, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, null, (Object)message, new Object[0]);
        }
    }

    public final void trace(@NotNull Throwable exception, @NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
        }
    }

    public final void trace(@NotNull Throwable exception, @NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void trace(@NotNull Throwable exception, @NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
            provider.log(2, null, Level.TRACE, exception, (MessageFormatter)formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
        }
    }

    public final boolean isDebugEnabled() {
        return MINIMUM_LEVEL_COVERS_DEBUG && provider.isEnabled(2, null, Level.DEBUG);
    }

    public final void debug(@Nullable Object message) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, null, message, new Object[0]);
        }
    }

    public final void debug(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, null, (Object)message, new Object[0]);
        }
    }

    public final void debug(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
        }
    }

    public final void debug(@NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void debug(@NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
            provider.log(2, null, Level.DEBUG, null, (MessageFormatter)formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
        }
    }

    public final void debug(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, null, null, new Object[0]);
        }
    }

    public final void debug(@NotNull Throwable exception, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, null, (Object)message, new Object[0]);
        }
    }

    public final void debug(@NotNull Throwable exception, @NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
        }
    }

    public final void debug(@NotNull Throwable exception, @NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void debug(@NotNull Throwable exception, @NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
            provider.log(2, null, Level.DEBUG, exception, (MessageFormatter)formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
        }
    }

    public final boolean isInfoEnabled() {
        return MINIMUM_LEVEL_COVERS_INFO && provider.isEnabled(2, null, Level.INFO);
    }

    public final void info(@Nullable Object message) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, null, message, new Object[0]);
        }
    }

    public final void info(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, null, (Object)message, new Object[0]);
        }
    }

    public final void info(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
        }
    }

    public final void info(@NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void info(@NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_INFO) {
            Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
            provider.log(2, null, Level.INFO, null, (MessageFormatter)formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
        }
    }

    public final void info(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, null, null, new Object[0]);
        }
    }

    public final void info(@NotNull Throwable exception, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, null, (Object)message, new Object[0]);
        }
    }

    public final void info(@NotNull Throwable exception, @NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
        }
    }

    public final void info(@NotNull Throwable exception, @NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void info(@NotNull Throwable exception, @NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_INFO) {
            Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
            provider.log(2, null, Level.INFO, exception, (MessageFormatter)formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
        }
    }

    public final boolean isWarnEnabled() {
        return MINIMUM_LEVEL_COVERS_WARN && provider.isEnabled(2, null, Level.WARN);
    }

    public final void warn(@Nullable Object message) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, null, message, new Object[0]);
        }
    }

    public final void warn(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, null, (Object)message, new Object[0]);
        }
    }

    public final void warn(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
        }
    }

    public final void warn(@NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void warn(@NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_WARN) {
            Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
            provider.log(2, null, Level.WARN, null, (MessageFormatter)formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
        }
    }

    public final void warn(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, null, null, new Object[0]);
        }
    }

    public final void warn(@NotNull Throwable exception, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, null, (Object)message, new Object[0]);
        }
    }

    public final void warn(@NotNull Throwable exception, @NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
        }
    }

    public final void warn(@NotNull Throwable exception, @NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void warn(@NotNull Throwable exception, @NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_WARN) {
            Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
            provider.log(2, null, Level.WARN, exception, (MessageFormatter)formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
        }
    }

    public final boolean isErrorEnabled() {
        return MINIMUM_LEVEL_COVERS_ERROR && provider.isEnabled(2, null, Level.ERROR);
    }

    public final void error(@Nullable Object message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, null, message, new Object[0]);
        }
    }

    public final void error(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, null, (Object)message, new Object[0]);
        }
    }

    public final void error(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
        }
    }

    public final void error(@NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void error(@NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
            provider.log(2, null, Level.ERROR, null, (MessageFormatter)formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
        }
    }

    public final void error(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, null, null, new Object[0]);
        }
    }

    public final void error(@NotNull Throwable exception, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, null, (Object)message, new Object[0]);
        }
    }

    public final void error(@NotNull Throwable exception, @NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
        }
    }

    public final void error(@NotNull Throwable exception, @NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void error(@NotNull Throwable exception, @NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
            provider.log(2, null, Level.ERROR, exception, (MessageFormatter)formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
        }
    }

    private final boolean isCoveredByMinimumLevel(Level level) {
        return provider.getMinimumLevel(null).ordinal() <= level.ordinal();
    }

    private Logger() {
    }

    static {
        Logger logger;
        INSTANCE = logger = new Logger();
        formatter = new AdvancedMessageFormatter(Configuration.getLocale(), Configuration.isEscapingEnabled());
        provider = ProviderRegistry.getLoggingProvider();
        MINIMUM_LEVEL_COVERS_TRACE = logger.isCoveredByMinimumLevel(Level.TRACE);
        MINIMUM_LEVEL_COVERS_DEBUG = logger.isCoveredByMinimumLevel(Level.DEBUG);
        MINIMUM_LEVEL_COVERS_INFO = logger.isCoveredByMinimumLevel(Level.INFO);
        MINIMUM_LEVEL_COVERS_WARN = logger.isCoveredByMinimumLevel(Level.WARN);
        MINIMUM_LEVEL_COVERS_ERROR = logger.isCoveredByMinimumLevel(Level.ERROR);
        instance = new TaggedLogger(SetsKt.setOf(null));
        loggers = new ConcurrentHashMap();
        ((Map)loggers).put(SetsKt.setOf(null), instance);
    }
}

