/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.activation;

import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.togglz.core.activation.AbstractTokenizedActivationStrategy;
import org.togglz.core.activation.Parameter;
import org.togglz.core.activation.ParameterBuilder;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.user.FeatureUser;
import org.togglz.spring.util.ContextClassLoaderApplicationContextHolder;

public class SpringProfileActivationStrategy
extends AbstractTokenizedActivationStrategy {
    public static final String ID = "spring-profile";
    public static final String PARAM_PROFILES = "profiles";

    private static List<String> getActiveProfileNames(ApplicationContext applicationContext) {
        String[] names = applicationContext.getEnvironment().getActiveProfiles();
        ArrayList<String> result = new ArrayList<String>(names.length);
        for (String name : names) {
            result.add(name.toLowerCase());
        }
        return result;
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Spring Profile";
    }

    public boolean isActive(FeatureState featureState, FeatureUser user, List<AbstractTokenizedActivationStrategy.Token> tokens) {
        ApplicationContext applicationContext = ContextClassLoaderApplicationContextHolder.get();
        if (applicationContext == null) {
            throw new IllegalStateException("ApplicationContext could not be found, which can occur if there is no bean for TogglzApplicationContextBinderApplicationListener when TogglzAutoConfiguration is not being used");
        }
        List<String> activeProfileNames = SpringProfileActivationStrategy.getActiveProfileNames(applicationContext);
        for (AbstractTokenizedActivationStrategy.Token token : tokens) {
            if (activeProfileNames.contains(token.getValue()) == token.isNegated()) continue;
            return true;
        }
        return false;
    }

    public Parameter[] getParameters() {
        return new Parameter[]{ParameterBuilder.create((String)PARAM_PROFILES).label("Profile Names").description("A comma-separated list of profile names for which the feature should be active. A profile can be negated by prefixing the name with the NOT operator (!).")};
    }

    public String getTokenParameterName() {
        return PARAM_PROFILES;
    }

    public AbstractTokenizedActivationStrategy.TokenTransformer getTokenParameterTransformer() {
        return new AbstractTokenizedActivationStrategy.TokenTransformer(){

            public String transform(String value) {
                return value.toLowerCase();
            }
        };
    }
}

