/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.xml;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.event.rule.ObjectInsertedEvent;
import org.drools.event.rule.ObjectRetractedEvent;
import org.drools.event.rule.ObjectUpdatedEvent;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.runtime.rule.FactHandle;
import org.tohu.Answer;
import org.tohu.InvalidAnswer;
import org.tohu.Item;
import org.tohu.Question;
import org.tohu.TohuObject;
import org.tohu.xml.ItemId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeCollector
implements WorkingMemoryEventListener {
    private transient Map<String, TohuObject> originalObjects;
    private transient Map<String, String> clientAnswers;
    private Map<Object, FactHandle> create;
    private List<Object> update;
    private List<Object> delete;

    Map<Object, FactHandle> getCreate() {
        return this.create;
    }

    List<Object> getUpdate() {
        return this.update;
    }

    List<Object> getDelete() {
        return this.delete;
    }

    public boolean initialised() {
        return this.originalObjects != null;
    }

    public void initialise(Collection<?> originalObjects) {
        this.originalObjects = new HashMap<String, TohuObject>();
        for (Object object : originalObjects) {
            if (object instanceof TohuObject) {
                TohuObject i = (TohuObject)object;
                try {
                    this.originalObjects.put(i.getId(), (TohuObject)i.clone());
                }
                catch (CloneNotSupportedException e) {}
                continue;
            }
            if (!(object instanceof Answer)) continue;
            Answer answer = (Answer)object;
            this.storeClientAnswer(answer);
        }
    }

    public void objectInserted(ObjectInsertedEvent event) {
        if (event.getObject() instanceof TohuObject) {
            TohuObject newObject = (TohuObject)event.getObject();
            String id = newObject.getId();
            TohuObject originalObject = this.getOriginalObject(id);
            this.processChange(id, originalObject, newObject, newObject, event.getFactHandle());
        } else if (event.getObject() instanceof Answer) {
            Answer answer = (Answer)event.getObject();
            this.storeClientAnswer(answer);
        }
    }

    public void objectUpdated(ObjectUpdatedEvent event) {
        if (event.getObject() instanceof TohuObject) {
            TohuObject newObject = (TohuObject)event.getObject();
            String id = newObject.getId();
            TohuObject originalObject = this.getOriginalObject(id);
            this.processChange(id, originalObject, newObject, newObject, event.getFactHandle());
        }
    }

    public void objectRetracted(ObjectRetractedEvent event) {
        if (event.getOldObject() instanceof TohuObject) {
            TohuObject oldObject = (TohuObject)event.getOldObject();
            String id = oldObject.getId();
            TohuObject originalObject = this.getOriginalObject(id);
            this.processChange(id, originalObject, null, oldObject, event.getFactHandle());
        }
    }

    private TohuObject getOriginalObject(String id) {
        boolean exists;
        if (this.originalObjects == null) {
            this.originalObjects = new HashMap<String, TohuObject>();
        }
        if (exists = this.originalObjects.containsKey(id)) {
            return this.originalObjects.get(id);
        }
        this.originalObjects.put(id, null);
        return null;
    }

    private void processChange(String id, TohuObject originalObject, TohuObject newObject, TohuObject recentObject, FactHandle factHandle) {
        boolean isDelete;
        if (this.create != null) {
            this.create.remove(recentObject);
        }
        if (this.update != null) {
            this.update.remove(recentObject);
        }
        if (this.delete != null) {
            if (recentObject instanceof InvalidAnswer) {
                this.delete.remove(recentObject);
            } else {
                this.delete.remove(new ItemId((Item)recentObject));
            }
        }
        boolean isCreate = (originalObject == null || !originalObject.isActive()) && newObject != null && newObject.isActive();
        boolean isUpdate = originalObject != null && originalObject.isActive() && newObject != null && newObject.isActive() && this.different(originalObject, newObject);
        boolean bl = isDelete = originalObject != null && originalObject.isActive() && (newObject == null || !newObject.isActive());
        if (isCreate) {
            if (this.create == null) {
                this.create = new HashMap<Object, FactHandle>();
            }
            this.create.put(newObject, factHandle);
        }
        if (isUpdate) {
            if (this.update == null) {
                this.update = new ArrayList<Object>();
            }
            this.update.add(newObject);
        }
        if (isDelete) {
            if (this.delete == null) {
                this.delete = new ArrayList<Object>();
            }
            if (recentObject instanceof InvalidAnswer) {
                this.delete.add(recentObject);
            } else {
                this.delete.add(new ItemId((Item)recentObject));
            }
        }
        if (this.create != null && this.create.isEmpty()) {
            this.create = null;
        }
        if (this.update != null && this.update.isEmpty()) {
            this.update = null;
        }
        if (this.delete != null && this.delete.isEmpty()) {
            this.delete = null;
        }
    }

    private boolean different(TohuObject originalObject, TohuObject newObject) {
        if (!originalObject.equals(newObject)) {
            return true;
        }
        if (originalObject instanceof Question) {
            String newAnswer;
            Question originalQuestion = (Question)originalObject;
            String originalAnswer = this.clientAnswers != null && this.clientAnswers.containsKey(originalQuestion.getId()) ? this.clientAnswers.get(originalQuestion.getId()) : (originalQuestion.getAnswer() == null ? null : originalQuestion.getAnswer().toString());
            Question newQuestion = (Question)newObject;
            String string = newAnswer = newQuestion.getAnswer() == null ? null : newQuestion.getAnswer().toString();
            if (originalAnswer == null ? newAnswer != null : !originalAnswer.equals(newAnswer)) {
                return true;
            }
        }
        Class<?> clazz = originalObject.getClass();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                boolean answerField;
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || (answerField = field.isAnnotationPresent(Question.AnswerField.class))) continue;
                field.setAccessible(true);
                try {
                    Object originalValue = field.get(originalObject);
                    Object newValue = field.get(newObject);
                    if (!(originalValue == null ? newValue != null : !originalValue.equals(newValue))) continue;
                    return true;
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    private void storeClientAnswer(Answer answer) {
        String answerValue;
        if (this.clientAnswers == null) {
            this.clientAnswers = new HashMap<String, String>();
        }
        if ((answerValue = answer.getValue()) != null && (answerValue.equals("") || answerValue.equals("null"))) {
            answerValue = null;
        }
        this.clientAnswers.put(answer.getQuestionId(), answerValue);
    }
}

