/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.auth.signatures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.tomitribe.auth.signatures.Algorithm;
import org.tomitribe.auth.signatures.AuthenticationException;
import org.tomitribe.auth.signatures.Join;
import org.tomitribe.auth.signatures.MissingAlgorithmException;
import org.tomitribe.auth.signatures.MissingKeyIdException;
import org.tomitribe.auth.signatures.MissingSignatureException;
import org.tomitribe.auth.signatures.UnparsableSignatureException;

public class Signature {
    private final String keyId;
    private final Algorithm algorithm;
    private final String signature;
    private final List<String> headers;

    public Signature(String keyId, String algorithm, String signature, String ... headers) {
        this(keyId, Signature.getAlgorithm(algorithm), signature, headers);
    }

    private static Algorithm getAlgorithm(String algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("Algorithm cannot be null");
        }
        return Algorithm.get(algorithm);
    }

    public Signature(String keyId, Algorithm algorithm, String signature, String ... headers) {
        this(keyId, algorithm, signature, Arrays.asList(headers));
    }

    public Signature(String keyId, String algorithm, String signature, List<String> headers) {
        this(keyId, Signature.getAlgorithm(algorithm), signature, headers);
    }

    public Signature(String keyId, Algorithm algorithm, String signature, List<String> headers) {
        if (keyId == null || keyId.trim().isEmpty()) {
            throw new IllegalArgumentException("keyId is required.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is required.");
        }
        this.keyId = keyId;
        this.algorithm = algorithm;
        this.signature = signature;
        if (headers.size() == 0) {
            List<String> list = Arrays.asList("date");
            this.headers = Collections.unmodifiableList(list);
        } else {
            this.headers = Collections.unmodifiableList(this.lowercase(headers));
        }
    }

    private List<String> lowercase(List<String> headers) {
        ArrayList<String> list = new ArrayList<String>(headers.size());
        for (String header : headers) {
            list.add(header.toLowerCase());
        }
        return list;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getSignature() {
        return this.signature;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public static Signature fromString(String authorization) {
        try {
            String keyid;
            authorization = Signature.normalize(authorization);
            String[] split = authorization.split(",");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String s : split) {
                s = s.trim();
                int i = s.indexOf("=\"");
                String key = s.substring(0, i).toLowerCase();
                String value = s.substring(i + 2, s.length() - 1);
                map.put(key, value);
            }
            ArrayList<String> headers = new ArrayList<String>();
            String headerString = (String)map.get("headers");
            if (headerString != null) {
                Collections.addAll(headers, headerString.toLowerCase().split(" +"));
            }
            if ((keyid = (String)map.get("keyid")) == null) {
                throw new MissingKeyIdException();
            }
            String algorithm = (String)map.get("algorithm");
            if (algorithm == null) {
                throw new MissingAlgorithmException();
            }
            String signature = (String)map.get("signature");
            if (signature == null) {
                throw new MissingSignatureException();
            }
            Algorithm parsedAlgorithm = Algorithm.get(algorithm);
            return new Signature(keyid, parsedAlgorithm, signature, headers);
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UnparsableSignatureException(authorization, e);
        }
    }

    private static String normalize(String authorization) {
        String start = "signature ";
        String prefix = authorization.substring(0, "signature ".length()).toLowerCase();
        if (prefix.equals("signature ")) {
            authorization = authorization.substring("signature ".length());
        }
        return authorization.trim();
    }

    public String toString() {
        return "Signature keyId=\"" + this.keyId + '\"' + ",algorithm=\"" + (Object)((Object)this.algorithm) + '\"' + ",headers=\"" + Join.join(" ", this.headers) + '\"' + ",signature=\"" + this.signature + '\"';
    }
}

